/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;

public abstract class AbstractDelegatedMethodInterceptor<T>
implements MethodInterceptor {
    private static Class[] EQUALS_PARAM_TYPES = new Class[]{Object.class};
    private static Class[] NO_PARAMS = new Class[0];
    private static CallbackFilter FINALIZER_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if ("finalize".equals(method.getName()) && Arrays.equals(NO_PARAMS, method.getParameterTypes())) {
                return 1;
            }
            return 0;
        }
    };

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if ("equals".equals(method.getName()) && Arrays.equals(EQUALS_PARAM_TYPES, method.getParameterTypes())) {
            return this.equals(args[0]);
        }
        if ("hashCode".equals(method.getName()) && Arrays.equals(NO_PARAMS, method.getParameterTypes())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName()) && Arrays.equals(NO_PARAMS, method.getParameterTypes())) {
            return this.toString();
        }
        T delegate = this.getDelegate();
        return proxy.invoke(delegate, args);
    }

    protected abstract T getDelegate();

    public static <T> T createProxy(Class<T> proxyClass, AbstractDelegatedMethodInterceptor<T> interceptor) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(proxyClass);
        enhancer.setCallbackFilter(FINALIZER_FILTER);
        enhancer.setCallbacks(new Callback[]{interceptor, NoOp.INSTANCE});
        return (T)enhancer.create();
    }
}

