/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database.jdbcurlparser;

import com.atlassian.jira.config.database.jdbcurlparser.AbstractJdbcUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.exception.ParseException;

public class PostgresUrlParser
extends AbstractJdbcUrlParser {
    @Override
    public String getUrl(String hostname, String port, String instance) throws ParseException {
        if (instance == null || instance.length() == 0) {
            throw new ParseException("Database is a required field");
        }
        String host = hostname.trim();
        port = ((String)(port = ((String)port).trim())).length() == 0 ? "" : ":" + (String)port;
        if (host.length() == 0) {
            if (((String)port).length() == 0) {
                return "jdbc:postgresql:" + instance.trim();
            }
            host = "localhost";
        }
        return "jdbc:postgresql://" + host + (String)port + "/" + instance.trim();
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        DatabaseInstance databaseInstance = new DatabaseInstance();
        String stripped = this.removeProtocolPrefix(jdbcUrl);
        if (!stripped.startsWith("//")) {
            databaseInstance.setInstance(stripped);
            return databaseInstance;
        }
        String[] hostPort_Database = (stripped = stripped.substring(2)).split("/", 2);
        if (hostPort_Database.length != 2) {
            throw new ParseException("Unable to parse the JDBC URL '" + jdbcUrl + "'. Missing '/' separator.");
        }
        databaseInstance.setInstance(hostPort_Database[1]);
        String[] hostPort = hostPort_Database[0].split(":");
        databaseInstance.setHostname(hostPort[0]);
        if (hostPort.length > 1) {
            databaseInstance.setPort(hostPort[1]);
        }
        return databaseInstance;
    }

    @Override
    protected String getProtocolPrefix() {
        return "jdbc:postgresql:";
    }
}

