/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureFlagProvider;
import com.atlassian.jira.config.feature.FeatureFlagParser;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FeatureFlagModuleDescriptor
extends AbstractModuleDescriptor<FeatureFlagProvider> {
    private static final Set<FeatureFlag> EMPTY_FLAGS = Collections.emptySet();
    private Set<FeatureFlag> staticDescriptorFlags = EMPTY_FLAGS;
    private final ResettableLazyReference<Option<FeatureFlagProvider>> moduleRef = new ResettableLazyReference<Option<FeatureFlagProvider>>(){

        protected Option<FeatureFlagProvider> create() {
            return Option.option((Object)((FeatureFlagProvider)SafePluginPointAccess.call(() -> {
                if (StringUtils.isEmpty((CharSequence)FeatureFlagModuleDescriptor.this.moduleClassName)) {
                    return null;
                }
                return (FeatureFlagProvider)FeatureFlagModuleDescriptor.this.moduleFactory.createModule(FeatureFlagModuleDescriptor.this.moduleClassName, (ModuleDescriptor)FeatureFlagModuleDescriptor.this);
            }).getOrNull()));
        }
    };

    public FeatureFlagModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.staticDescriptorFlags = FeatureFlagParser.parseFlags(element);
    }

    public FeatureFlagProvider getModule() {
        return (FeatureFlagProvider)((Option)this.moduleRef.get()).getOrNull();
    }

    public Set<FeatureFlag> getFeatureFlags() {
        Option moduleFlags = Option.option((Object)((Set)SafePluginPointAccess.call(() -> {
            Option provider = Option.option((Object)this.getModule());
            if (provider.isDefined()) {
                return (Set)Option.option((Object)((FeatureFlagProvider)provider.get()).getFeatureFlags()).getOrElse(EMPTY_FLAGS);
            }
            return EMPTY_FLAGS;
        }).getOrNull()));
        HashSet flags = Sets.newHashSet();
        flags.addAll(this.staticDescriptorFlags);
        flags.addAll((Collection)moduleFlags.getOrElse(EMPTY_FLAGS));
        return flags;
    }
}

