/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.filestore;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.config.ConfigParseException;
import com.atlassian.jira.config.filestore.FileStoreAssociationConfig;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.FileStoreConfig;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class FileStoresConfig {
    private final Map<String, Either<ConfigParseException, FileStoreConfig>> fileStoreConfigs;
    final Map<FileStoreAssociationTarget, FileStoreAssociationConfig> associationConfigs;

    public FileStoresConfig(Map<String, Either<ConfigParseException, FileStoreConfig>> fileStoreConfigs, Map<FileStoreAssociationTarget, FileStoreAssociationConfig> associationConfigs) {
        this.fileStoreConfigs = Collections.unmodifiableMap(new HashMap<String, Either<ConfigParseException, FileStoreConfig>>(fileStoreConfigs));
        this.associationConfigs = Collections.unmodifiableMap(new HashMap<FileStoreAssociationTarget, FileStoreAssociationConfig>(associationConfigs));
    }

    public Map<String, Either<ConfigParseException, FileStoreConfig>> getFileStoreConfigs() {
        return this.fileStoreConfigs;
    }

    public Optional<FileStoreAssociationConfig> getAssociation(FileStoreAssociationTarget target) {
        return Optional.ofNullable(this.associationConfigs.get((Object)target));
    }
}

