/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.filestore;

import com.atlassian.jira.config.ConfigParseException;
import com.atlassian.jira.config.CustomConfigHandler;
import com.atlassian.jira.config.filestore.FileStoreAssociationConfig;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.FileStoreConfig;
import com.atlassian.jira.config.filestore.FileStoreConfigType;
import com.atlassian.jira.config.filestore.FileStoresConfig;
import com.atlassian.jira.config.filestore.S3FileStoreConfig;
import com.google.common.base.CaseFormat;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Pair;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class FileStoresConfigHandler
implements CustomConfigHandler<FileStoresConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStoresConfigHandler.class);
    private static final String ROOT_ELEMENT_XPATH = "/filestore-config";
    private static final String ASSOCIATIONS_ELEMENT_XPATH = "/filestore-config/associations";
    private static final String FILESTORES_ELEMENT_XPATH = "/filestore-config/filestores";
    private static final String FILESTORES_ELEMENT_DIRECT_CHILDREN_XPATH = "/filestore-config/filestores/*";
    private static final String ASSOCIATIONS_ELEMENT_DIRECT_CHILDREN_XPATH = "/filestore-config/associations/*";
    private static final String FILE_STORE_ATTRIBUTE = "file-store";
    private static final String TARGET_ATTRIBUTE = "target";
    private static final String ASSOCIATION_ELEMENT_NAME = "association";
    private static final String S3_CONFIG_BUCKET_NAME_XPATH = "config/bucket-name";
    private static final String S3_CONFIG_REGION_XPATH = "config/region";
    private static final String S3_MAX_CONCURRENCY_XPATH = "config/max-concurrency";
    private static final String S3_CONFIG_ENDPOINT_OVERRIDE_XPATH = "config/endpoint-override";
    public static final String FILESTORE_CANNOT_BE_PARSED_MESSAGE = String.format("Jira couldn't parse the %s file because a filestore element has a missing or blank ID.", "filestore-config.xml");

    @Override
    public Class<FileStoresConfig> getBeanClass() {
        return FileStoresConfig.class;
    }

    @Override
    public FileStoresConfig parse(Element element) {
        FileStoresConfigHandler.validateSingleElement(element, ROOT_ELEMENT_XPATH);
        FileStoresConfigHandler.validateSingleElement(element, FILESTORES_ELEMENT_XPATH);
        FileStoresConfigHandler.validateSingleElement(element, ASSOCIATIONS_ELEMENT_XPATH);
        Map<String, Either<ConfigParseException, FileStoreConfig>> fileStoreConfigs = element.selectNodes(FILESTORES_ELEMENT_DIRECT_CHILDREN_XPATH).stream().filter(Element.class::isInstance).map(Element.class::cast).filter(this::isValidFileStoreElement).map(this::parseFileStoreConfig).collect(Collectors.toMap(Pair::left, Pair::right));
        Map<FileStoreAssociationTarget, FileStoreAssociationConfig> associationConfigMap = this.parseAssociations(element, fileStoreConfigs);
        return new FileStoresConfig(fileStoreConfigs, associationConfigMap);
    }

    private Map<FileStoreAssociationTarget, FileStoreAssociationConfig> parseAssociations(Element element, Map<String, Either<ConfigParseException, FileStoreConfig>> fileStoreConfigs) {
        return element.selectNodes(ASSOCIATIONS_ELEMENT_DIRECT_CHILDREN_XPATH).stream().filter(Element.class::isInstance).map(Element.class::cast).filter(this::isValidAssociationElement).map(el -> this.parseAssociationConfig(fileStoreConfigs, (Element)el)).collect(Collectors.toMap(FileStoreAssociationConfig::getTarget, Function.identity(), (k1, k2) -> {
            throw new ConfigParseException(String.format("There are multiple associations with the target '%s'. Each target can have only one association. Remove the extra associations and try again.", k1));
        }));
    }

    @Nonnull
    private FileStoreAssociationConfig parseAssociationConfig(Map<String, Either<ConfigParseException, FileStoreConfig>> fileStoreConfigs, Element associationElement) {
        FileStoreAssociationTarget target;
        String targetString = Optional.ofNullable(associationElement.attributeValue(TARGET_ATTRIBUTE)).orElseThrow(() -> new ConfigParseException("The association is missing the target attribute."));
        String targetUpper = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, targetString.trim());
        try {
            target = FileStoreAssociationTarget.valueOf(targetUpper);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigParseException(String.format("The association has an unknown target '%s'.", targetString));
        }
        String fileStoreId = associationElement.attributeValue(FILE_STORE_ATTRIBUTE);
        return new FileStoreAssociationConfig(target, (Either<ConfigParseException, FileStoreConfig>)Optional.ofNullable(fileStoreId).map(fileStoreConfigs::get).orElseGet(() -> Either.left((Object)new ConfigParseException(fileStoreId == null ? String.format("The target '%s' is missing the %s attribute.", targetString, FILE_STORE_ATTRIBUTE) : String.format("Jira couldn't find a filestore with the ID '%s' that's required for the association with target '%s'.", fileStoreId, targetString)))));
    }

    private static void validateSingleElement(Element parent, String xpathExpression) {
        List nodes = parent.selectNodes(xpathExpression).stream().filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
        String elementName = xpathExpression.substring(xpathExpression.lastIndexOf(47) + 1);
        if (nodes.size() != 1) {
            throw new ConfigParseException(String.format("A single <%s> element was expected in the %s file, but %d were encountered. Make sure that the %s file contains only a single <%s> element.", elementName, "filestore-config.xml", nodes.size(), "filestore-config.xml", elementName));
        }
    }

    private Pair<String, Either<ConfigParseException, FileStoreConfig>> parseFileStoreConfig(Element fileStoreElement) {
        String id = fileStoreElement.attributeValue("id");
        return FileStoreConfigType.fromElementName(fileStoreElement.getName()).map(configType -> {
            if (configType == FileStoreConfigType.S3) {
                return Pair.pair((Object)id, this.parseS3FileStoreConfig(fileStoreElement, id));
            }
            return Pair.pair((Object)id, (Object)Either.left((Object)new ConfigParseException(String.format("A parser for '%s' has not been implemented", configType))));
        }).orElseGet(() -> Pair.pair((Object)id, (Object)Either.left((Object)new ConfigParseException(String.format("The %s file could not be parsed because the filestore with element name '%s' is not valid.", "filestore-config.xml", fileStoreElement.getName())))));
    }

    private boolean isValidFileStoreElement(Element fileStoreElement) {
        return FileStoresConfigHandler.validateNotBlank(fileStoreElement.attributeValue("id"), FILESTORE_CANNOT_BE_PARSED_MESSAGE, new Object[0]).isRight();
    }

    private boolean isValidAssociationElement(Element associationElement) {
        boolean hasCorrectElementName = Objects.equals(associationElement.getName(), ASSOCIATION_ELEMENT_NAME);
        if (!hasCorrectElementName) {
            LOGGER.warn("Invalid element name '{}' in associations has been ignored.", (Object)associationElement.getName());
        }
        return hasCorrectElementName;
    }

    private static Either<ConfigParseException, String> validateNotBlank(String string, String message, Object ... formatArgs) {
        if (StringUtils.isBlank((CharSequence)string)) {
            String formattedMessage = String.format(message, formatArgs);
            LOGGER.warn(formattedMessage);
            return Either.left((Object)new ConfigParseException(formattedMessage));
        }
        return Either.right((Object)string);
    }

    private static Either<ConfigParseException, String> parseAndValidateNodeText(@Nullable Node node, String message, Object ... formatArgs) {
        if (node == null || StringUtils.isBlank((CharSequence)node.getText())) {
            String formattedMessage = String.format(message, formatArgs);
            LOGGER.warn(formattedMessage);
            return Either.left((Object)new ConfigParseException(formattedMessage));
        }
        return Either.right((Object)node.getText().trim());
    }

    private Either<ConfigParseException, FileStoreConfig> parseS3FileStoreConfig(Element element, String id) {
        return FileStoresConfigHandler.parseAndValidateNodeText(element.selectSingleNode(S3_CONFIG_BUCKET_NAME_XPATH), "Jira couldn't parse the %s file because the filestore with ID '%s' has a missing or blank config/bucket-name element.", "filestore-config.xml", id).flatMap(bucketName -> FileStoresConfigHandler.parseAndValidateNodeText(element.selectSingleNode(S3_CONFIG_REGION_XPATH), "Jira couldn't parse the %s file because the filestore with ID '%s' has a missing or blank config/region element.", "filestore-config.xml", id).flatMap(region -> {
            Node endpointOverrideNode = element.selectSingleNode(S3_CONFIG_ENDPOINT_OVERRIDE_XPATH);
            Node maxConcurrency = element.selectSingleNode(S3_MAX_CONCURRENCY_XPATH);
            Optional<String> endpointOverrideOptional = Optional.ofNullable(endpointOverrideNode).map(Node::getText).map(String::trim);
            Optional endpointOverrideValidationException = endpointOverrideOptional.flatMap(endpointOverride -> {
                try {
                    URI.create(endpointOverride);
                    return Optional.empty();
                }
                catch (IllegalArgumentException e) {
                    return Optional.of(new ConfigParseException(String.format("Jira couldn't parse the %s with the ID '%s' because 'endpointOverride' isn't a valid URI: %s", "filestore-config.xml", id, endpointOverride)));
                }
            });
            if (endpointOverrideValidationException.isPresent()) {
                return Either.left((Object)((ConfigParseException)endpointOverrideValidationException.get()));
            }
            Optional<Either> maxConcurrencyEither = Optional.ofNullable(maxConcurrency).map(Node::getText).map(String::trim).map(maxConcurrencyString -> {
                try {
                    int maxConcurrencyIntLocal = Integer.parseInt(maxConcurrencyString);
                    if (maxConcurrencyIntLocal < 1) {
                        return Either.left((Object)new ConfigParseException(String.format("Jira couldn't parse the %s with the ID '%s' because 'maxConcurrency' is less than 1: %s", "filestore-config.xml", id, maxConcurrencyString)));
                    }
                    return Either.right((Object)maxConcurrencyIntLocal);
                }
                catch (NumberFormatException e) {
                    return Either.left((Object)new ConfigParseException(String.format("Jira couldn't parse the %s with the ID '%s' because 'maxConcurrency' isn't a valid integer: %s", "filestore-config.xml", id, maxConcurrencyString)));
                }
            });
            if (maxConcurrencyEither.isPresent() && maxConcurrencyEither.get().left().isDefined()) {
                return Either.left((Object)((ConfigParseException)maxConcurrencyEither.get().left().get()));
            }
            return Either.right((Object)new S3FileStoreConfig(id, (String)bucketName, (String)region, maxConcurrencyEither.isPresent() ? (Integer)maxConcurrencyEither.map(l -> l.right()).get().getOrNull() : null, endpointOverrideOptional.orElse(null)));
        }));
    }

    @Override
    public void writeTo(Element element, FileStoresConfig fileStoresConfig) {
        throw new NotImplementedException("Changes must be made to filestore config manually.");
    }
}

