/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.filestore;

import com.atlassian.jira.config.filestore.FileStoreConfig;
import com.atlassian.jira.config.filestore.FileStoreConfigType;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class S3FileStoreConfig
implements FileStoreConfig {
    private final FileStoreConfigType type = FileStoreConfigType.S3;
    private final String id;
    private final String bucketName;
    private final String region;
    @Nullable
    private final Integer maxConcurrency;
    @Nullable
    private final String endpointOverride;

    public S3FileStoreConfig(String id, String bucketName, String region, @Nullable Integer maxConcurrency, @Nullable String endpointOverride) {
        this.id = Objects.requireNonNull(id);
        this.bucketName = Objects.requireNonNull(bucketName);
        this.region = Objects.requireNonNull(region);
        this.maxConcurrency = maxConcurrency;
        this.endpointOverride = endpointOverride;
    }

    @Override
    public FileStoreConfigType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getRegion() {
        return this.region;
    }

    @Nullable
    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Nullable
    public String getEndpointOverride() {
        return this.endpointOverride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3FileStoreConfig that = (S3FileStoreConfig)o;
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.bucketName.equals(that.bucketName)) {
            return false;
        }
        if (!this.region.equals(that.region)) {
            return false;
        }
        if (!Objects.equals(this.maxConcurrency, that.maxConcurrency)) {
            return false;
        }
        return Objects.equals(this.endpointOverride, that.endpointOverride);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.bucketName.hashCode();
        result = 31 * result + this.region.hashCode();
        result = 31 * result + (this.endpointOverride != null ? this.endpointOverride.hashCode() : 0);
        result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", S3FileStoreConfig.class.getSimpleName() + "[", "]").add("type='" + this.type + "'").add("id='" + this.id + "'").add("bucketName='" + this.bucketName + "'").add("region='" + this.region + "'").add("maxConcurrency='" + this.maxConcurrency + "'").add("endpointOverride='" + this.endpointOverride + "'").toString();
    }
}

