/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LnFDefaultColorProvider;
import com.atlassian.jira.config.properties.LogoProvider;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.config.properties.UiSettingsStateManager;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class UiSettingsStateManagerImpl
implements UiSettingsStateManager {
    private final ApplicationProperties applicationProperties;
    private final LookAndFeelBean lookAndFeelBean;
    private final CachedReference<String> systemHash;

    public UiSettingsStateManagerImpl(ApplicationProperties applicationProperties, CacheManager cacheManager) {
        this.applicationProperties = applicationProperties;
        this.lookAndFeelBean = new LookAndFeelBean((UiSettingsStateManager)this, applicationProperties, (LnFDefaultColorProvider)ComponentAccessor.getComponent(LnFDefaultColorProvider.class), (LogoProvider)ComponentAccessor.getComponent(LogoProvider.class));
        this.systemHash = cacheManager.getCachedReference(UiSettingsStateManagerImpl.class.getName(), this::generateNewSettingsHash, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().build());
    }

    public String getStateHash() {
        return (String)this.systemHash.get();
    }

    public void invalidateStateHash() {
        this.systemHash.reset();
    }

    private String generateNewSettingsHash() {
        String settingsHash = this.calculateHash();
        this.applicationProperties.setString("jira.webresource.flushcounter", settingsHash);
        return settingsHash;
    }

    @Nonnull
    private String calculateHash() {
        Hasher hasher = Hashing.murmur3_32().newHasher();
        hasher.putString((CharSequence)this.lookAndFeelBean.getConfigurationState(), Charset.defaultCharset());
        WebResourceIntegration webResourceIntegration = (WebResourceIntegration)ComponentAccessor.getComponent(WebResourceIntegration.class);
        CDNStrategy cdnStrategy = webResourceIntegration.getCDNStrategy();
        if (cdnStrategy != null && cdnStrategy.supportsCdn()) {
            hasher.putString((CharSequence)cdnStrategy.encodeConfigurationState(), Charset.defaultCharset());
        }
        return Long.toString(hasher.hash().padToLong(), 36);
    }
}

