/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties.v2;

import com.atlassian.jira.config.properties.ApplicationPropertiesManager;
import com.atlassian.jira.config.properties.ApplicationProperty;
import com.atlassian.jira.config.properties.v2.ApplicationPropertiesConstants;
import com.atlassian.jira.propertyset.OfBizPropertyTypeRegistry;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ApplicationPropertiesBackedPropertySet
extends AbstractPropertySet {
    private static final int TYPE_ALL = 0;
    private static final Map<Integer, Class<?>> TYPE_TO_SAFE_COMPATIBLE_CLASS = ImmutableMap.of((Object)1, Boolean.class, (Object)3, Long.class, (Object)4, Double.class, (Object)5, String.class, (Object)6, String.class);
    private final ApplicationPropertiesManager manager;

    public ApplicationPropertiesBackedPropertySet(ApplicationPropertiesManager manager) {
        this.manager = manager;
    }

    @Nullable
    protected Object get(int type, String key) throws PropertyException {
        return this.manager.get(key).map(property -> {
            Object value = property.getValue();
            if (value == null) {
                return null;
            }
            if (TYPE_TO_SAFE_COMPATIBLE_CLASS.get(type) == value.getClass()) {
                return value;
            }
            return OfBizPropertyTypeRegistry.mapper(type).getHandler().processGet(type, value);
        }).orElse(null);
    }

    public Collection getKeys(@Nullable String prefix, int type) throws PropertyException {
        Stream keys = prefix == null ? (type == 0 ? this.manager.getAllKeys() : this.manager.getAllKeys(ApplicationPropertiesConstants.OFBIZ_TO_TYPE_MAP.get(type))) : (type == 0 ? this.manager.getAllKeys(prefix) : this.manager.getAllKeys(prefix, ApplicationPropertiesConstants.OFBIZ_TO_TYPE_MAP.get(type)));
        return keys.collect(Collectors.toList());
    }

    public int getType(String key) throws PropertyException {
        return this.manager.get(key).map(ApplicationProperty::getType).map(ApplicationPropertiesConstants.TYPE_TO_OFBIZ_MAP::get).orElseThrow(() -> new PropertyImplementationException("Property '" + key + "' not found"));
    }

    public boolean exists(String key) {
        return this.manager.exists(key);
    }

    public void remove(String key) throws PropertyException {
        this.manager.delete(key);
    }

    public void remove() throws PropertyException {
        this.manager.deleteAll();
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        ApplicationProperty property = new ApplicationProperty(key, ApplicationPropertiesConstants.OFBIZ_TO_TYPE_MAP.get(type), value);
        this.manager.save(property);
    }

    public boolean supportsType(int type) {
        switch (type) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return false;
            }
        }
        return true;
    }
}

