/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties.v2;

import com.atlassian.jira.config.properties.ApplicationPropertiesManager;
import com.atlassian.jira.config.properties.ApplicationProperty;
import com.atlassian.jira.config.properties.v2.ApplicationPropertiesConstants;
import com.opensymphony.module.propertyset.memory.MemoryPropertySet;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PropertySetBackedApplicationPropertiesManager
implements ApplicationPropertiesManager {
    private final MemoryPropertySet propertySet;

    public PropertySetBackedApplicationPropertiesManager(MemoryPropertySet propertySet) {
        this.propertySet = propertySet;
    }

    public void delete(String key) {
        this.propertySet.remove(key);
    }

    public void deleteAll() {
        this.propertySet.remove();
    }

    public boolean exists(String key) {
        return this.propertySet.exists(key);
    }

    @Nonnull
    public Optional<ApplicationProperty> get(String key) {
        if (!this.propertySet.exists(key)) {
            return Optional.empty();
        }
        int type = this.propertySet.getType(key);
        Object value = this.propertySet.getAsActualType(key);
        if (value instanceof Integer) {
            value = (long)((Integer)value).intValue();
        }
        return Optional.of(new ApplicationProperty(key, ApplicationPropertiesConstants.OFBIZ_TO_TYPE_MAP.get(type), value));
    }

    @Nonnull
    public Stream<ApplicationProperty> getAll() {
        return this.propertySet.getKeys().stream().map(this::get).filter(Optional::isPresent).map(Optional::get);
    }

    @Nonnull
    public Stream<String> getAllKeys() {
        return this.propertySet.getKeys().stream();
    }

    @Nonnull
    public Stream<String> getAllKeys(String keyPrefix) {
        return this.propertySet.getKeys(keyPrefix).stream();
    }

    @Nonnull
    public Stream<String> getAllKeys(ApplicationProperty.Type type) {
        Collection keys = this.propertySet.getKeys(ApplicationPropertiesConstants.TYPE_TO_OFBIZ_MAP.get(type).intValue());
        if (type == ApplicationProperty.Type.INTEGER) {
            keys.addAll(this.propertySet.getKeys(2));
        }
        return keys.stream();
    }

    @Nonnull
    public Stream<String> getAllKeys(String keyPrefix, ApplicationProperty.Type type) {
        Collection keys = this.propertySet.getKeys(keyPrefix, ApplicationPropertiesConstants.TYPE_TO_OFBIZ_MAP.get(type).intValue());
        if (type == ApplicationProperty.Type.INTEGER) {
            keys.addAll(this.propertySet.getKeys(keyPrefix, 2));
        }
        return keys.stream();
    }

    @Nonnull
    public ApplicationProperty save(ApplicationProperty property) {
        String key = property.getKey();
        Object value = property.getValue();
        if (property.getType() == ApplicationProperty.Type.TEXT) {
            this.propertySet.setText(key, (String)value);
        } else {
            this.propertySet.setAsActualType(key, value);
        }
        return property;
    }
}

