/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemAccess;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentConfig;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.config.util.ExtensionRestrictionMode;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class DefaultAttachmentConfigStore
implements AttachmentConfigStore {
    private static final int FILTERED_FILE_EXT_MAX_LENGTH = 255;
    private final ApplicationProperties applicationProperties;
    private final AttachmentFileStoreProvider attachmentFileStoreProvider;

    public DefaultAttachmentConfigStore(ApplicationProperties applicationProperties, AttachmentFileStoreProvider attachmentFileStoreProvider) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.attachmentFileStoreProvider = Objects.requireNonNull(attachmentFileStoreProvider);
    }

    private Optional<FileStore.Path> getAttachmentPath() {
        if (!this.isAttachmentsEnabled()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attachmentFileStoreProvider.getBasePath());
    }

    @Override
    @Nonnull
    public AttachmentConfig getConfig() {
        return new AttachmentConfig(this.getAttachmentPath().orElse(null), this.isAttachmentsEnabled(), this.isAllowThumbnailsEnabled(), this.isZipSupportEnabled(), this.getMaxAttachmentSize(), this.getExtensionRestrictionMode(), this.getFilteredFileExtensions(), this.isFilterFilesWithoutExtensions());
    }

    @Override
    public ErrorCollection setConfig(AttachmentConfig config) {
        ErrorCollection errors = this.validateConfig(config);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        if (config.isAttachmentsEnabled() != this.isAttachmentsEnabled()) {
            this.setAttachmentsEnabled(config.isAttachmentsEnabled());
        }
        this.setAllowThumbnailsEnabled(config.isThumbnailsEnabled() && config.isAttachmentsEnabled());
        this.setZipSupportEnabled(config.isZipSupportEnabled());
        if (config.isAttachmentsEnabled()) {
            this.setMaxAttachmentSize(config.getMaxAttachmentSize());
        }
        this.setExtensionRestrictionMode(config.getExtensionRestrictionMode());
        this.setFilteredFileExtensions(config.getFilteredFileExtensions());
        this.setFilterFilesWithoutExtensions(config.isFilterFilesWithoutExtensions());
        return new SimpleErrorCollection();
    }

    @Override
    public ErrorCollection validateConfig(AttachmentConfig config) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (config.isAttachmentsEnabled()) {
            this.validateCustomFileSystemAttachmentPath(config, (ErrorCollection)errors);
            this.validateAttachmentSize(config, (ErrorCollection)errors);
        } else {
            if (config.isThumbnailsEnabled()) {
                errors.addErrorMessage("admin.errors.attachments.must.be.enabled.to.enable.thumbnails");
            }
            if (config.isZipSupportEnabled()) {
                errors.addErrorMessage("admin.errors.attachments.must.be.enabled.to.enable.zip.support");
            }
        }
        this.validateFilteredFileExtensions(config, (ErrorCollection)errors);
        return errors;
    }

    @Override
    @Nonnull
    public FileStoreAnalyticInfo getFileStoreAnalyticInfo() {
        return this.attachmentFileStoreProvider.getFileStoreAnalyticInfo();
    }

    @VisibleForTesting
    void validateCustomFileSystemAttachmentPath(AttachmentConfig config, ErrorCollection errors) {
        String attachmentPathFieldName = "attachmentPath";
        Optional<FileStore.Path> attachmentPath = config.getAttachmentPath();
        attachmentPath.filter(FilesystemPath.class::isInstance).map(FilesystemPath.class::cast).map(FilesystemAccess::asJavaFile).ifPresent(file -> {
            this.tryToCreateAttachmentPath((File)file);
            if (!file.exists() || !file.isDirectory()) {
                errors.addError("attachmentPath", "admin.errors.path.entered.does.not.exist");
            } else if (!file.canRead() || !file.canWrite()) {
                errors.addError("attachmentPath", "admin.errors.path.entered.is.not.readable");
            }
        });
    }

    private void tryToCreateAttachmentPath(File actualPath) {
        if (!actualPath.exists()) {
            actualPath.mkdirs();
        }
    }

    private void validateAttachmentSize(AttachmentConfig config, ErrorCollection errors) {
        String maxAttachmentSizeFieldName = "maxAttachmentSize";
        if (config.getMaxAttachmentSize() <= 0L) {
            errors.addError("maxAttachmentSize", "admin.errors.attachments.size.must.be.positive");
        } else if (config.getMaxAttachmentSize() > Integer.MAX_VALUE) {
            errors.addError("maxAttachmentSize", "admin.errors.attachments.size.must.be.between.maxint");
        }
    }

    @VisibleForTesting
    void validateFilteredFileExtensions(AttachmentConfig config, ErrorCollection errors) {
        String filteredFileExtensionsFieldName = "filteredFileExtensions";
        if (config.getFilteredFileExtensions().length() > 255) {
            errors.addError("filteredFileExtensions", "admin.errors.attachments.invalid.filtered.file.extensions");
        }
    }

    private void setAttachmentsEnabled(boolean enabled) {
        this.applicationProperties.setOption("jira.option.allowattachments", enabled);
    }

    private boolean isAttachmentsEnabled() {
        return this.applicationProperties.getOption("jira.option.allowattachments");
    }

    private void setZipSupportEnabled(boolean enabled) {
        this.applicationProperties.setOption("jira.attachment.allow.zip.support", enabled);
    }

    private boolean isZipSupportEnabled() {
        return this.applicationProperties.getOption("jira.attachment.allow.zip.support");
    }

    private void setAllowThumbnailsEnabled(boolean enabled) {
        this.applicationProperties.setOption("jira.option.allowthumbnails", enabled);
    }

    private boolean isAllowThumbnailsEnabled() {
        return this.applicationProperties.getOption("jira.option.allowthumbnails");
    }

    private void setMaxAttachmentSize(long maxAttachmentSize) {
        this.applicationProperties.setString("webwork.multipart.maxSize", String.valueOf(maxAttachmentSize));
    }

    private long getMaxAttachmentSize() {
        return Long.parseLong(this.applicationProperties.getDefaultBackedString("webwork.multipart.maxSize"));
    }

    private ExtensionRestrictionMode getExtensionRestrictionMode() {
        return ExtensionRestrictionMode.fromKey((String)this.applicationProperties.getString("jira.attachment.extension.restriction.mode")).orElse(ExtensionRestrictionMode.NONE);
    }

    private void setExtensionRestrictionMode(ExtensionRestrictionMode filteringMode) {
        this.applicationProperties.setString("jira.attachment.extension.restriction.mode", filteringMode.getKey());
    }

    private String getFilteredFileExtensions() {
        return StringUtils.defaultString((String)this.applicationProperties.getString("jira.attachment.filtered.file.extensions"));
    }

    private void setFilteredFileExtensions(String filteredFileExtensions) {
        this.applicationProperties.setString("jira.attachment.filtered.file.extensions", filteredFileExtensions);
    }

    private boolean isFilterFilesWithoutExtensions() {
        return this.applicationProperties.getOption("jira.attachment.filter.files.without.extensions");
    }

    private void setFilterFilesWithoutExtensions(boolean filterFilesWithoutExtension) {
        this.applicationProperties.setOption("jira.attachment.filter.files.without.extensions", filterFilesWithoutExtension);
    }
}

