/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.config.util.JiraHome;
import java.util.Objects;

@ReturnValuesAreNonnullByDefault
public class JiraHomeFileStores
implements FileStores {
    private final JiraHome jiraHome;

    public JiraHomeFileStores(JiraHome jiraHome) {
        this.jiraHome = Objects.requireNonNull(jiraHome);
    }

    @Override
    public FilesystemPath getHomeFilesystemPath() {
        return new FilesystemFileStore(this.jiraHome.getHome().toPath()).root();
    }

    @Override
    public FilesystemPath getLocalHomeFilesystemPath() {
        return new FilesystemFileStore(this.jiraHome.getLocalHome().toPath()).root();
    }

    @Override
    public FilesystemPath getLogPath() {
        return new FilesystemFileStore(this.jiraHome.getLogDirectory().toPath()).root();
    }

    @Override
    public FilesystemPath getExportPath() {
        return new FilesystemFileStore(this.jiraHome.getExportDirectory().toPath()).root();
    }

    @Override
    public FilesystemPath getExportBackupsPath() {
        return new FilesystemFileStore(this.jiraHome.getExportBackupsDirectory().toPath()).root();
    }

    @Override
    public FilesystemPath getImportPath() {
        return new FilesystemFileStore(this.jiraHome.getImportDirectory().toPath()).root();
    }

    @Override
    public FilesystemPath getImportAttachmentsPath() {
        return new FilesystemFileStore(this.jiraHome.getImportAttachmentsDirectory().toPath()).root();
    }

    @Override
    public FilesystemPath getIndexSnapshotsPath() {
        return new FilesystemFileStore(this.jiraHome.getIndexSnapshotsDirectory().toPath()).root();
    }
}

