/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AbstractJiraHome;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.event.ReplicationSettingsConfiguredEvent;
import com.atlassian.jira.util.PathUtils;
import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class SecondaryJiraHome
extends AbstractJiraHome {
    private final ApplicationProperties applicationProperties;
    private final JiraHome primaryHome;
    private final ClusterManager clusterManager;
    private final EventPublisher eventPublisher;
    private volatile File location;

    public SecondaryJiraHome(JiraHome jirahome, ApplicationProperties applicationProperties, ClusterManager clusterManager, EventPublisher eventPublisher) {
        this.applicationProperties = applicationProperties;
        this.primaryHome = jirahome;
        this.clusterManager = clusterManager;
        this.eventPublisher = eventPublisher;
        boolean isEnabled = applicationProperties.getOption("jira.secondary.storage");
        this.refreshLocation(isEnabled);
    }

    @Nonnull
    public File getLocalHome() {
        return this.location;
    }

    public String getDefaultPath() {
        return PathUtils.joinPaths((String[])new String[]{this.primaryHome.getHomePath(), "secondary"});
    }

    public void setEnabled(boolean value) {
        this.applicationProperties.setOption("jira.secondary.storage", value);
        this.refreshLocation(value);
    }

    public boolean isEnabled() {
        return this.applicationProperties.getOption("jira.secondary.storage") && this.clusterManager.isClusterLicensed();
    }

    public void applySettings(boolean attachments, boolean plugins, boolean indexSnapshots, boolean avatars) {
        boolean replicationEnabled = attachments || plugins || indexSnapshots || avatars;
        this.applicationProperties.setOption(JiraHomeChangeEvent.FileType.ATTACHMENT.getKey(), attachments);
        this.applicationProperties.setOption(JiraHomeChangeEvent.FileType.PLUGIN.getKey(), plugins);
        this.applicationProperties.setOption(JiraHomeChangeEvent.FileType.INDEX_SNAPSHOT.getKey(), indexSnapshots);
        this.applicationProperties.setOption(JiraHomeChangeEvent.FileType.AVATAR.getKey(), avatars);
        this.setEnabled(replicationEnabled);
        this.eventPublisher.publish((Object)new ReplicationSettingsConfiguredEvent(attachments, plugins, avatars, indexSnapshots));
    }

    protected void refreshLocation(boolean isEnabled) {
        String customPath;
        this.location = isEnabled ? new File(StringUtils.isNotBlank((CharSequence)(customPath = this.applicationProperties.getDefaultBackedString("jira.secondary.home"))) ? customPath : this.getDefaultPath()) : null;
    }
}

