/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.jira.config.webwork.JiraPluginActionFactory;
import com.atlassian.jira.config.webwork.LookupAliasActionFactoryProxy;
import com.atlassian.jira.config.webwork.SafeActionFactoryProxy;
import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.jira.security.annotated.AnnotatedSecurityEnabledCheck;
import com.atlassian.jira.servlet.ServletRequestUtil;
import com.atlassian.jira.util.Supplier;
import com.google.common.annotations.VisibleForTesting;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ChainingActionFactoryProxy;
import webwork.action.factory.CommandActionFactoryProxy;
import webwork.action.factory.ContextActionFactoryProxy;
import webwork.action.factory.JspActionFactoryProxy;
import webwork.action.factory.PrefixActionFactoryProxy;
import webwork.action.factory.PrepareActionFactoryProxy;
import webwork.action.factory.ReloadHelperActionFactoryProxy;
import webwork.config.Configuration;
import webwork.util.ValueStack;

public class JiraActionFactory
extends ActionFactory {
    private final ActionFactory factory;
    private final JiraPluginActionFactory rootActionFactory;

    public JiraActionFactory() {
        this(new AnnotatedSecurityEnabledCheck(), (Supplier<AnnotatedSecurityChecker>)((Supplier)ServletRequestUtil::getSecurityChecker));
    }

    @VisibleForTesting
    JiraActionFactory(AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck, Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        this.rootActionFactory = new JiraPluginActionFactory();
        this.factory = this.createActionFactory(annotatedSecurityEnabledCheck, securityCheckerSupplier);
    }

    private ActionFactory createActionFactory(AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck, Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        Object factory = this.rootActionFactory;
        factory = new PrefixActionFactoryProxy((ActionFactory)factory);
        factory = new JspActionFactoryProxy((ActionFactory)factory);
        factory = new CommandActionFactoryProxy((ActionFactory)factory);
        factory = new LookupAliasActionFactoryProxy((ActionFactory)factory);
        factory = new CommandActionFactoryProxy((ActionFactory)factory);
        factory = new ContextActionFactoryProxy((ActionFactory)factory);
        factory = new PrepareActionFactoryProxy((ActionFactory)factory);
        factory = new SafeActionFactoryProxy((ActionFactory)factory, annotatedSecurityEnabledCheck, securityCheckerSupplier);
        factory = new ChainingActionFactoryProxy((ActionFactory)factory);
        try {
            boolean reloadEnabled = "true".equalsIgnoreCase(Configuration.getString((String)"webwork.configuration.xml.reload"));
            if (reloadEnabled) {
                factory = new ReloadHelperActionFactoryProxy((ActionFactory)factory);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return factory;
    }

    @Deprecated
    public JiraActionFactory(ActionFactory factory, JiraPluginActionFactory rootActionFactory) {
        this.factory = factory;
        this.rootActionFactory = rootActionFactory;
    }

    public Action getActionImpl(String actionName) throws Exception {
        return this.factory.getActionImpl(actionName);
    }

    public void flushCaches() {
        this.factory.flushCaches();
        ValueStack.clearMethods();
    }

    void setPluginClassLoader(ClassLoader classLoader) {
        this.rootActionFactory.setPluginClassLoader(classLoader);
    }
}

