/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.webwork.ActionNotFoundException;
import com.atlassian.jira.plugin.webwork.AutowireCapableWebworkActionRegistry;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.util.ClassLoaderUtils;
import webwork.util.injection.ObjectFactory;

class JiraPluginActionFactory
extends ActionFactory {
    private static final Logger log = LoggerFactory.getLogger(JiraPluginActionFactory.class);
    private final Listener shutdownListener = new Listener();
    @ClusterSafe
    private final ConcurrentMap<String, Class<Action>> actionMappingCache = new ConcurrentHashMap<String, Class<Action>>();
    private volatile ClassLoader pluginClassLoader;
    private final ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();

    JiraPluginActionFactory() {
    }

    @GuardedBy(value="cacheLock.readLock")
    public Action getActionImpl(String actionName) throws Exception {
        Action action;
        Class<Action> actionClass = (Class<Action>)this.actionMappingCache.get(actionName);
        if (actionClass == null) {
            actionClass = this.loadFromPluginClassLoader(actionName);
            if (actionClass == null) {
                actionClass = this.loadFromSystemClassLoaders(actionName);
            }
            if (actionClass == null) {
                throw new ActionNotFoundException(actionName);
            }
        }
        String actionSimpleName = actionClass.getSimpleName();
        AutowireCapableWebworkActionRegistry autowireCapableWebworkActionRegistry = this.getAutowireCapableWebworkActionRegistry();
        if (autowireCapableWebworkActionRegistry.containsAction(actionSimpleName)) {
            try {
                action = (Action)autowireCapableWebworkActionRegistry.getPlugin(actionSimpleName).getContainerAccessor().createBean(actionClass);
            }
            catch (Exception ex) {
                log.error("Error autowiring Action '" + actionClass.getName() + "'.", (Throwable)ex);
                throw ex;
            }
        } else {
            action = this.instantiateAction(actionName, actionClass);
        }
        if (!JiraSystemProperties.getInstance().isDevMode()) {
            this.actionMappingCache.putIfAbsent(actionName, actionClass);
        }
        return action;
    }

    private AutowireCapableWebworkActionRegistry getAutowireCapableWebworkActionRegistry() {
        return (AutowireCapableWebworkActionRegistry)ComponentAccessor.getComponentOfType(AutowireCapableWebworkActionRegistry.class);
    }

    private Action instantiateAction(String actionName, Class<? extends Action> actionClass) {
        if (!Action.class.isAssignableFrom(actionClass)) {
            throw new IllegalArgumentException("Attempt to invoke a class that is not an action '" + actionName + "'");
        }
        try {
            return (Action)ObjectFactory.instantiate(actionClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Action '" + actionName + "' could not be instantiated - " + e);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("Action '" + actionName + "' could not be instantiated. Class is invalid or static initializers have failed to run");
        }
    }

    @GuardedBy(value="cacheLock.writeLock")
    public void flushCaches() {
        this.actionMappingCache.clear();
    }

    void setPluginClassLoader(ClassLoader classLoader) {
        this.pluginClassLoader = classLoader;
        EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class);
        eventPublisher.register((Object)this.shutdownListener);
        this.flushCaches();
    }

    private Class<Action> loadFromPluginClassLoader(String name) {
        ClassLoader pluginClassLoaderNonVolatile = this.pluginClassLoader;
        if (pluginClassLoaderNonVolatile != null) {
            try {
                Class<Action> result = pluginClassLoaderNonVolatile.loadClass(name);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Class<Action> loadFromSystemClassLoaders(String name) {
        try {
            Class<Action> actionClass = this.systemClassLoader.loadClass(name);
            return actionClass;
        }
        catch (ClassNotFoundException e) {
            try {
                return ClassLoaderUtils.loadClass((String)name, ((Object)((Object)this)).getClass());
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public class Listener {
        @EventListener
        public void onShutdown(PluginFrameworkShutdownEvent event) {
            JiraPluginActionFactory.this.pluginClassLoader = null;
            JiraPluginActionFactory.this.flushCaches();
        }
    }
}

