/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.webwork.ActionNotFoundException;
import com.atlassian.jira.config.webwork.actions.ActionConfiguration;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.sal.core.permission.AccessType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;

public class LookupAliasActionFactoryProxy
extends ActionFactoryProxy {
    @ClusterSafe
    private ConcurrentMap<String, ActionConfiguration.Entry> actionAliases = new ConcurrentHashMap<String, ActionConfiguration.Entry>();

    public LookupAliasActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
    }

    public Action getActionImpl(String alias) throws Exception {
        ActionConfiguration.Entry actionCommand = (ActionConfiguration.Entry)this.actionAliases.get(alias);
        if (actionCommand == null) {
            actionCommand = this.getActionConfiguration().getActionCommand(alias);
            if (actionCommand == null) {
                throw new ActionNotFoundException(alias);
            }
            ActionConfiguration.Entry fromMap = this.actionAliases.putIfAbsent(alias, actionCommand);
            if (fromMap != null) {
                actionCommand = fromMap;
            }
        }
        this.authorise(actionCommand);
        return this.getNextFactory().getActionImpl(actionCommand.toActionFactoryString());
    }

    private void authorise(ActionConfiguration.Entry actionCommand) {
        for (Integer permission : actionCommand.getPermissionsRequired()) {
            if (this.getPermissionManager().hasPermission(permission.intValue(), this.getJiraAuthenticationContext().getUser())) continue;
            throw new UnauthorisedActionException(permission);
        }
    }

    private PermissionManager getPermissionManager() {
        return (PermissionManager)ComponentAccessor.getComponent(PermissionManager.class);
    }

    private JiraAuthenticationContext getJiraAuthenticationContext() {
        return (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
    }

    private ActionConfiguration getActionConfiguration() {
        return (ActionConfiguration)ComponentAccessor.getComponent(ActionConfiguration.class);
    }

    public void flushCaches() {
        this.getNextFactory().flushCaches();
        this.actionAliases.clear();
    }

    public static class UnauthorisedActionException
    extends RuntimeException {
        private final AccessType accessType;

        UnauthorisedActionException(Integer permissionId) {
            this.accessType = UnauthorisedActionException.toAccessType(permissionId);
        }

        private static AccessType toAccessType(Integer permission) {
            GlobalPermissionKey globalPermissionKey = (GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permission);
            if (GlobalPermissionKey.SYSTEM_ADMIN.equals((Object)globalPermissionKey)) {
                return AccessType.SYSTEM_ADMIN_ONLY;
            }
            if (GlobalPermissionKey.ADMINISTER.equals((Object)globalPermissionKey)) {
                return AccessType.ADMIN_ONLY;
            }
            return AccessType.LICENSED_ONLY;
        }

        public AccessType getAccessType() {
            return this.accessType;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

