/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.action.SafeAction;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.jira.security.annotated.AnnotatedSecurityEnabledCheck;
import com.atlassian.jira.security.annotated.SecureDefaultsStats;
import com.atlassian.jira.security.request.RequestMethodCheckFailureException;
import com.atlassian.jira.security.request.RequestMethodCheckResult;
import com.atlassian.jira.security.request.RequestMethodChecker;
import com.atlassian.jira.security.request.SecurityAnnotationException;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfFailureException;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.webwork.JiraSafeActionParameterSetter;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.sal.core.permission.AccessType;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.CommandDriven;
import webwork.action.ResultException;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.util.BeanUtil;

class SafeActionFactoryProxy
extends ActionFactoryProxy {
    private static final Logger log = LoggerFactory.getLogger(SafeActionFactoryProxy.class);
    private final JiraSafeActionParameterSetter parameterSetter;
    private final AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck;
    private final Supplier<AnnotatedSecurityChecker> securityChecker;

    SafeActionFactoryProxy(ActionFactory actionFactory, AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck, Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        super(actionFactory);
        this.annotatedSecurityEnabledCheck = annotatedSecurityEnabledCheck;
        this.parameterSetter = new JiraSafeActionParameterSetter();
        this.securityChecker = securityCheckerSupplier;
    }

    public Action getActionImpl(String actionAlias) throws Exception {
        Action action = this.getNextFactory().getActionImpl(actionAlias);
        if (action != null) {
            this.checkSecurityAnnotations(action, SafeActionFactoryProxy.getActionMethodName(action), actionAlias);
            this.checkRequestMethod(action);
            this.checkXsrfStatus(action);
            this.checkWebSudoStatus(action.getClass());
            this.setActionParameters(action);
        }
        return action;
    }

    private void checkSecurityAnnotations(Action actionImpl, String methodName, String actionAlias) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.annotatedSecurityEnabledCheck.isAnnotatedSecurityDisabled()) {
            return;
        }
        AccessType accessType = AccessType.getAccessType(actionImpl.getClass(), (String)methodName, (Class[])new Class[0]);
        if (!((AnnotatedSecurityChecker)this.securityChecker.get()).isAllowedFor(accessType)) {
            ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.actionNotAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
            throw new SecurityAnnotationException("Insufficient permissions to execute action.", actionImpl.getClass(), methodName, accessType);
        }
        ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.actionAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
    }

    private static String getActionMethodName(Action actionImpl) {
        String methodName;
        if (actionImpl instanceof CommandDriven && ((CommandDriven)actionImpl).getCommandName() != null && !((CommandDriven)actionImpl).getCommandName().isEmpty()) {
            StringBuilder sb = new StringBuilder("do");
            sb.append(((CommandDriven)actionImpl).getCommandName());
            sb.setCharAt(2, Character.toUpperCase(sb.charAt(2)));
            methodName = sb.toString();
        } else {
            methodName = "doExecute";
        }
        return methodName;
    }

    private void checkRequestMethod(Action action) {
        if (ComponentAccessor.getComponentSafely(FeatureManager.class).map(featureManager -> featureManager.isEnabled(JiraFeatureFlagRegistrar.WEBACTIONS_REQUEST_METHOD_RECOGNITION)).orElse(false).booleanValue()) {
            HttpServletRequest request = ActionContext.getRequest();
            DispatcherType dispatcherType = request.getDispatcherType();
            if (dispatcherType == DispatcherType.ERROR) {
                return;
            }
            String method = request.getMethod();
            RequestMethodCheckResult result = this.getRequestMethodChecker().checkActionInvocation(action, method);
            if (!result.isMethodSupported()) {
                throw new RequestMethodCheckFailureException(result, action);
            }
        }
    }

    private RequestMethodChecker getRequestMethodChecker() {
        return (RequestMethodChecker)ComponentAccessor.getComponent(RequestMethodChecker.class);
    }

    private void checkXsrfStatus(Action action) {
        Map parameters = ActionContext.getParameters();
        XsrfInvocationChecker xsrfInvocationChecker = this.getXsrfInvocationChecker();
        XsrfCheckResult xsrfCheckResult = xsrfInvocationChecker.checkActionInvocation(action, parameters);
        if (xsrfCheckResult.isRequired()) {
            boolean sessionExpired = this.sessionExpired(xsrfCheckResult);
            if (!xsrfCheckResult.isValid() || sessionExpired) {
                throw new XsrfFailureException(action, xsrfCheckResult);
            }
        }
    }

    private void checkWebSudoStatus(Class<? extends Action> action) {
        InternalWebSudoManager webSudoManager = this.getInternalWebSudoManager();
        if (webSudoManager.isEnabled() && webSudoManager.matches(action)) {
            if (webSudoManager.hasValidSession(ActionContext.getRequest().getSession())) {
                webSudoManager.markWebSudoRequest(ActionContext.getRequest());
            } else {
                PermissionManager permissionManager = (PermissionManager)ComponentAccessor.getComponent(PermissionManager.class);
                JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
                if (jiraAuthenticationContext.getLoggedInUser() == null && permissionManager.hasPermission(0, (ApplicationUser)null)) {
                    webSudoManager.startSession(ActionContext.getRequest(), ActionContext.getResponse());
                } else {
                    throw new WebSudoSessionException("No websudo session and it is required");
                }
            }
        }
    }

    private boolean sessionExpired(XsrfCheckResult xsrfCheckResult) {
        ApplicationUser currentUser = this.getAuthenticationContext().getLoggedInUser();
        return xsrfCheckResult.isGeneratedForAuthenticatedUser() && currentUser == null;
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
    }

    XsrfInvocationChecker getXsrfInvocationChecker() {
        return (XsrfInvocationChecker)ComponentAccessor.getComponent(XsrfInvocationChecker.class);
    }

    InternalWebSudoManager getInternalWebSudoManager() {
        return (InternalWebSudoManager)ComponentAccessor.getComponent(InternalWebSudoManager.class);
    }

    private void setActionParameters(Action action) throws ResultException {
        Map parameters = ActionContext.getParameters();
        if (log.isDebugEnabled()) {
            this.debugActionParameters(action, parameters);
        }
        try {
            if (action instanceof SafeAction) {
                BeanUtil.setProperties((Map)parameters, (Object)action);
            } else {
                this.parameterSetter.setSafeParameters(action, parameters);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ResultException("error");
        }
    }

    private <C extends Comparable<C>> void debugActionParameters(Action action, Map<C, ?> parameters) {
        Set<C> keySet;
        if (log.isDebugEnabled() && action != null && !(keySet = parameters.keySet()).isEmpty()) {
            ArrayList<C> keys = new ArrayList<C>(keySet);
            Collections.sort(keys);
            String requestURL = "BackEnd Action";
            if (ActionContext.getRequest() != null && ActionContext.getRequest().getRequestURL() != null) {
                requestURL = ActionContext.getRequest().getRequestURL().toString();
            }
            log.debug("JAFP {} - {}", (Object)action.getClass().getName(), (Object)requestURL);
            for (Object key : keys) {
                log.debug("JAFP param={} value={}", key, (Object)this.valStr(parameters.get(key)));
            }
            log.debug("JAFP ------");
        }
    }

    private String valStr(Object value) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            sb.append(value.getClass().getName()).append(" - ");
        }
        if (value instanceof String[]) {
            for (String val : (String[])value) {
                sb.append(val).append(", ");
            }
        } else {
            sb.append(value);
        }
        return sb.toString();
    }
}

