/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.service.cluster.ClusterInformation;
import com.atlassian.crowd.service.cluster.ClusterNode;
import com.atlassian.crowd.service.cluster.ClusterNodeDetails;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.Node;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JiraClusterService
implements ClusterService {
    public static final String SINGLE_NODE_ID = "single-node";
    private final ClusterNodes clusterNodes;

    public JiraClusterService(ClusterNodes clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public boolean isAvailable() {
        return this.clusterNodes.current().isClustered();
    }

    @Nonnull
    public String getNodeId() {
        return Optional.ofNullable(this.clusterNodes.current().getNodeId()).orElse(SINGLE_NODE_ID);
    }

    public Optional<ClusterNode> getClusterNode() {
        String nodeId = this.clusterNodes.current().getNodeId();
        return this.getInformation().getNodes().stream().filter(node -> node.getNodeId().equals(nodeId)).findFirst();
    }

    @Nonnull
    public ClusterInformation getInformation() {
        return new ClusterInformation(){
            final Set<Node> nodes;
            final boolean singleNode;
            final String localNodeId;
            final Function<Node, ClusterNode> toClusterNodeFunc;
            {
                this.nodes = JiraClusterService.this.clusterNodes.all();
                this.singleNode = !JiraClusterService.this.isAvailable();
                this.localNodeId = JiraClusterService.this.getNodeId();
                this.toClusterNodeFunc = node -> new ClusterNode(){
                    final /* synthetic */ Node val$node;
                    {
                        this.val$node = node;
                    }

                    public String getNodeId() {
                        return this.val$node.getNodeId();
                    }

                    public String getNodeName() {
                        return this.getNodeId();
                    }

                    public Instant getLastHeartbeat() {
                        return Instant.ofEpochMilli(this.val$node.getTimestamp());
                    }

                    public boolean isLocal() {
                        return singleNode || localNodeId.equals(this.getNodeId());
                    }

                    public Optional<ClusterNodeDetails> getDetails() {
                        return Optional.empty();
                    }
                };
            }

            public Set<ClusterNode> getNodes() {
                return this.nodes.stream().map(this.toClusterNodeFunc).collect(Collectors.toSet());
            }
        };
    }
}

