/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.event.application.ApplicationReadyEvent;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRefresherJob;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRefresherStarter;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJobRunner;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.time.Clock;

public class JiraDirectorySynchronisationAggregate
implements Startable {
    public static final JobRunnerKey DIRECTORY_POLLER_JOB_RUNNER_KEY = DirectoryPollerJobRunner.JOB_RUNNER_KEY;
    private static final long REFRESHER_JOB_INTERVAL_MILLIS = 120000L;
    private final EventPublisher eventPublisher;
    private final DirectoryMonitorRefresherStarter directoryMonitorRefresherStarter;
    private final DirectoryMonitorRefresherJob directoryMonitorRefresherJob;
    private final DirectoryPollerJobRunner directoryPollerJobRunner;

    public JiraDirectorySynchronisationAggregate(EventPublisher eventPublisher, SchedulerService schedulerService, DirectoryInstanceLoader directoryInstanceLoader, DirectoryManager directoryManager, DirectorySynchroniser directorySynchroniser, ClusterLockService clusterLockService, ClusterManager clusterManager, Clock clock) {
        this.eventPublisher = eventPublisher;
        this.directoryMonitorRefresherStarter = new DirectoryMonitorRefresherStarter(eventPublisher, schedulerService, 120000L);
        this.directoryMonitorRefresherJob = new DirectoryMonitorRefresherJob(schedulerService, directoryInstanceLoader, directoryManager, clusterLockService, clock, clusterManager::isClusterLicensed);
        this.directoryPollerJobRunner = new DirectoryPollerJobRunner(directoryManager, directorySynchroniser, directoryInstanceLoader, schedulerService);
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
        this.directoryMonitorRefresherStarter.registerListener();
        this.directoryMonitorRefresherJob.registerJobRunner();
        this.directoryPollerJobRunner.register();
    }

    @EventListener
    public void onJiraStartedEvent(JiraStartedEvent event) {
        this.simulateApplicationReadyEventForDirectoryMonitorRefresherStarter();
    }

    @EventListener
    public void onJiraUpgradeFinishedEvent(JiraUpgradeFinishedEvent event) {
        this.simulateApplicationReadyEventForDirectoryMonitorRefresherStarter();
    }

    private void simulateApplicationReadyEventForDirectoryMonitorRefresherStarter() {
        this.directoryMonitorRefresherStarter.onApplicationReady(new ApplicationReadyEvent((Object)this));
    }
}

