/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import java.io.Serializable;
import javax.annotation.Nonnull;

final class DirectoryEntityKey
implements Serializable {
    private final long directoryId;
    @Nonnull
    private final String name;

    @Nonnull
    public static DirectoryEntityKey getKeyPreserveCase(long directoryId, String name) {
        return new DirectoryEntityKey(directoryId, name);
    }

    @Nonnull
    public static DirectoryEntityKey getKeyLowerCase(long directoryId, String name) {
        return new DirectoryEntityKey(directoryId, IdentifierUtils.toLowerCase((String)name));
    }

    @Nonnull
    public static DirectoryEntityKey getKeyLowerCase(@Nonnull DirectoryEntity entity) {
        if (entity instanceof UserOrGroupStub) {
            return DirectoryEntityKey.getKeyFor((UserOrGroupStub)entity);
        }
        return new DirectoryEntityKey(entity.getDirectoryId(), IdentifierUtils.toLowerCase((String)entity.getName()));
    }

    public static DirectoryEntityKey getKeyFor(@Nonnull UserOrGroupStub stub) {
        return new DirectoryEntityKey(stub.getDirectoryId(), stub.getLowerName());
    }

    private DirectoryEntityKey(long directoryId, @Nonnull String name) {
        this.directoryId = directoryId;
        this.name = name;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DirectoryEntityKey && this.equals((DirectoryEntityKey)o);
    }

    private boolean equals(@Nonnull DirectoryEntityKey other) {
        return this.directoryId == other.directoryId && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = (int)(this.directoryId ^ this.directoryId >>> 32);
        return 31 * hash + this.name.hashCode();
    }

    public String toString() {
        return "{" + this.directoryId + "," + this.name + "}";
    }
}

