/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.DirectorySynchronisationTokenDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QDirectorySynchronisationToken;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import javax.annotation.Nullable;

public class OfBizDirectorySynchronisationTokenDao
implements DirectorySynchronisationTokenDao {
    private final QueryDslAccessor queryDslAccessor;
    private final DirectoryDao directoryDao;

    public OfBizDirectorySynchronisationTokenDao(QueryDslAccessor queryDslAccessor, DirectoryDao directoryDao) {
        this.queryDslAccessor = queryDslAccessor;
        this.directoryDao = directoryDao;
    }

    @Nullable
    public String getLastSynchronisationTokenForDirectory(long directoryId) {
        return this.queryDslAccessor.executeQuery(dbConnection -> (String)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN.synchronisationToken).from((Expression)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN)).where((Predicate)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN.id.eq((Object)directoryId))).fetchOne());
    }

    public void storeSynchronisationTokenForDirectory(long directoryId, String synchronisationToken) throws DirectoryNotFoundException {
        long rowCount = this.queryDslAccessor.executeQuery(dbConnection -> dbConnection.update((RelationalPath<?>)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN).set((Path)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN.synchronisationToken, (Object)synchronisationToken).where((Predicate)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN.id.eq((Object)directoryId)).execute());
        if (rowCount == 0L) {
            this.directoryDao.findById(directoryId);
            this.queryDslAccessor.execute(dbConnection -> dbConnection.insert(QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN).set((Path)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN.id, (Object)directoryId).set((Path)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN.synchronisationToken, synchronisationToken).execute());
        }
    }

    public void clearSynchronisationTokenForDirectory(long directoryId) {
        this.queryDslAccessor.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN).where((Predicate)QDirectorySynchronisationToken.DIRECTORY_SYNCHRONISATION_TOKEN.id.eq((Object)directoryId)).execute());
    }
}

