/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.DashboardItemStateVisitor;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationImpl;
import com.atlassian.plugin.ModuleCompleteKey;
import io.atlassian.fugue.Option;
import java.net.URI;

class DashboardItemStateConverter {
    DashboardItemStateConverter() {
    }

    PortletConfiguration toPortletConfiguration(DashboardItemState dashboardItemState, final Long page, final Integer column, final Integer row) {
        final long itemId = DashboardUtil.toLong((GadgetId)dashboardItemState.getId());
        return (PortletConfiguration)dashboardItemState.accept((DashboardItemStateVisitor)new DashboardItemStateVisitor<PortletConfiguration>(){

            public PortletConfiguration visit(GadgetState state) {
                return new PortletConfigurationImpl(itemId, page, column, row, (Option<URI>)Option.some((Object)state.getGadgetSpecUri()), state.getColor(), state.getUserPrefs(), (Option<ModuleCompleteKey>)Option.none());
            }

            public PortletConfiguration visit(LocalDashboardItemState state) {
                Option openSocialSpecUri = Option.option((Object)((URI)state.getDashboardItemModuleId().getReplacedGadgetId().map(OpenSocialDashboardItemModuleId::getSpecUri).getOrNull()));
                Option moduleKey = Option.some((Object)state.getDashboardItemModuleId().getFullModuleKey());
                return new PortletConfigurationImpl(itemId, page, column, row, (Option<URI>)openSocialSpecUri, state.getColor(), state.getProperties(), (Option<ModuleCompleteKey>)moduleKey);
            }
        });
    }
}

