/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.ConnectionFunction;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseConnection;
import com.atlassian.jira.database.DatabaseConnectionImpl;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.NestedConnection;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.util.concurrent.LazyReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericTransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseAccessorImpl
implements DatabaseAccessor {
    private static final Logger log = LoggerFactory.getLogger(DatabaseAccessorImpl.class);
    private final LazyReference<DatabaseDetails> databaseDetails;
    private final OfBizConnectionFactory ofBizConnectionFactory;

    public DatabaseAccessorImpl(final DatabaseConfigurationManager databaseConfigurationManager, OfBizConnectionFactory ofBizConnectionFactory) {
        this.ofBizConnectionFactory = ofBizConnectionFactory;
        this.databaseDetails = new LazyReference<DatabaseDetails>(){

            protected DatabaseDetails create() {
                DatabaseConfig databaseConfig = databaseConfigurationManager.getDatabaseConfiguration();
                return new DatabaseDetails(DatabaseAccessorImpl.this.findDatabaseVendor(databaseConfig), databaseConfig.getDatabaseType(), StringUtils.trimToNull((String)databaseConfig.getSchemaName()));
            }
        };
    }

    @Nonnull
    public DatabaseVendor getDatabaseVendor() {
        DatabaseVendor databaseVendor = Objects.requireNonNull((DatabaseDetails)this.databaseDetails.get()).vendor;
        if (databaseVendor == DatabaseVendor.UNSUPPORTED) {
            throw new IllegalStateException("Unrecognised database dialect '" + this.getDatabaseType() + "'.");
        }
        return databaseVendor;
    }

    @Nonnull
    public String getDatabaseType() {
        return Objects.requireNonNull((DatabaseDetails)this.databaseDetails.get()).type;
    }

    @Nonnull
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(Objects.requireNonNull((DatabaseDetails)this.databaseDetails.get()).schema);
    }

    public <R> R executeQuery(@Nonnull ConnectionFunction<R> callback) {
        Connection con = this.borrowConnection();
        try {
            Object object = callback.run((DatabaseConnection)new DatabaseConnectionImpl(con));
            return (R)object;
        }
        catch (RuntimeException ex) {
            try {
                if (!con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (SQLException sqlEx) {
                log.error("Unable to rollback SQL connection.", (Throwable)sqlEx);
            }
            throw ex;
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.error("Unable to close SQL connection.", (Throwable)ex);
            }
        }
    }

    public <R> R runInTransaction(@Nonnull Function<Connection, R> callback) {
        Connection existingConnection = CoreTransactionUtil.getConnection();
        if (existingConnection == null) {
            return this.executeQuery(conn -> {
                conn.setAutoCommit(false);
                NestedConnection nestedConection = new NestedConnection(conn.getJdbcConnection());
                Object returnVal = callback.apply(nestedConection);
                conn.commit();
                return returnVal;
            });
        }
        NestedConnection nestedConection = new NestedConnection(existingConnection);
        try {
            return callback.apply(nestedConection);
        }
        catch (RuntimeException ex) {
            this.setRollbackOnlyOnOfBizTransaction();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R runInManagedTransaction(@Nonnull Function<Connection, R> callback) {
        Transaction transaction = Txn.begin();
        try {
            R result = callback.apply(transaction.getNestedConnection());
            transaction.commit();
            R r = result;
            return r;
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <R> Optional<R> runInManagedOptionalAwareTransaction(@Nonnull Function<Connection, Optional<R>> callback) {
        Transaction transaction = Txn.begin();
        try {
            Optional result = (Optional)Assertions.notNull((String)"callback result", callback.apply(transaction.getNestedConnection()));
            result.ifPresent(r -> transaction.commit());
            Optional optional = result;
            return optional;
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    private void setRollbackOnlyOnOfBizTransaction() {
        try {
            CoreTransactionUtil.setRollbackOnly(false);
        }
        catch (GenericTransactionException e) {
            log.error("Unable to mark transaction rollback only", (Throwable)e);
        }
    }

    private Connection borrowConnection() {
        try {
            return this.ofBizConnectionFactory.getConnection();
        }
        catch (SQLException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    @Nonnull
    private DatabaseVendor findDatabaseVendor(DatabaseConfig databaseConfig) {
        if (databaseConfig.isMySql()) {
            return DatabaseVendor.MY_SQL;
        }
        if (databaseConfig.isPostgres()) {
            return DatabaseVendor.POSTGRES;
        }
        if (databaseConfig.isOracle()) {
            return DatabaseVendor.ORACLE;
        }
        if (databaseConfig.isSqlServer()) {
            return DatabaseVendor.SQL_SERVER;
        }
        if (databaseConfig.isH2()) {
            return DatabaseVendor.H2;
        }
        return DatabaseVendor.UNSUPPORTED;
    }

    public String getVersion() {
        return (String)this.executeQuery(c -> {
            try {
                return c.getJdbcConnection().getMetaData().getDatabaseProductVersion();
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot execute health check as database version lookup is failing due to: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @ParametersAreNonnullByDefault
    private static class DatabaseDetails {
        private final DatabaseVendor vendor;
        private final String schema;
        private final String type;

        private DatabaseDetails(DatabaseVendor vendor, String type, @Nullable String schema) {
            this.schema = schema;
            this.type = Objects.requireNonNull(type);
            this.vendor = Objects.requireNonNull(vendor);
        }
    }
}

