/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database.measure;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.measure.DatabaseLatencyMeasuredEvent;
import com.atlassian.jira.database.measure.DatabaseLatencyMeter;
import com.atlassian.jira.database.measure.DatabaseQueryMeter;
import com.atlassian.jira.database.measure.LatencyQueryStringGenerator;
import java.time.Duration;
import java.util.Optional;

public class CheapSelectDatabaseLatencyMeter
implements DatabaseLatencyMeter {
    private final DatabaseAccessor databaseAccessor;
    private final DatabaseQueryMeter databaseQueryMeter;
    private final EventPublisher eventPublisher;
    private final LatencyQueryStringGenerator queryGenerator;

    public CheapSelectDatabaseLatencyMeter(DatabaseAccessor databaseAccessor, DatabaseQueryMeter databaseQueryMeter, EventPublisher eventPublisher) {
        this.databaseAccessor = databaseAccessor;
        this.databaseQueryMeter = databaseQueryMeter;
        this.eventPublisher = eventPublisher;
        this.queryGenerator = new LatencyQueryStringGenerator();
    }

    @Override
    public Duration measure() {
        Duration latency = null;
        try {
            Duration duration = latency = this.measureWithoutEvent();
            return duration;
        }
        finally {
            this.eventPublisher.publish((Object)new DatabaseLatencyMeasuredEvent(Optional.ofNullable(latency)));
        }
    }

    @Override
    public Duration measureWithoutEvent() {
        String sql = this.queryGenerator.createQueryString(this.databaseAccessor.getSchemaName());
        return (Duration)this.databaseAccessor.executeQuery(databaseConnection -> this.databaseQueryMeter.measure(databaseConnection.getJdbcConnection(), sql));
    }
}

