/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic.connection;

import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseDiagnosticsCollector;
import com.atlassian.diagnostics.internal.platform.monitor.db.SqlOperation;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DatabaseDiagnosticsCollectorDelegate
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(DatabaseDiagnosticsCollectorDelegate.class);
    private static final String DIAGNOSTICS_PLUGIN_KEY = "com.atlassian.jira.diagnostics";
    private boolean pluginSystemHasStarted = false;
    private final ResettableLazyReference<Optional<DatabaseDiagnosticsCollector>> delegate = Lazy.resettable(() -> {
        try {
            return Optional.ofNullable((DatabaseDiagnosticsCollector)ComponentAccessor.getOSGiComponentInstanceOfType(DatabaseDiagnosticsCollector.class));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    });

    public boolean isEnabled() {
        return ((Optional)this.delegate.get()).isPresent();
    }

    public void trackConnection(Connection connection) {
        try {
            ((Optional)this.delegate.get()).ifPresent(collector -> collector.trackConnection(connection));
        }
        catch (Exception exception) {
            log.debug("Wasn't able to start tracking DB connection", (Throwable)exception);
        }
    }

    public void removeTrackedConnection(Connection connection) {
        try {
            ((Optional)this.delegate.get()).ifPresent(collector -> collector.removeTrackedConnection(connection));
        }
        catch (Exception exception) {
            log.debug("Wasn't able to stop tracking DB connection", (Throwable)exception);
        }
    }

    public <T> T recordExecutionTime(SqlOperation<T> operation, String sql) throws SQLException {
        if (((Optional)this.delegate.get()).isPresent()) {
            return (T)((DatabaseDiagnosticsCollector)((Optional)this.delegate.get()).get()).recordExecutionTime(operation, sql);
        }
        return (T)operation.execute();
    }

    public void start() {
        this.delegate.reset();
    }

    @EventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        this.pluginSystemHasStarted = true;
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (this.pluginSystemHasStarted && this.isDiagnosticsPlugin((PluginEvent)event)) {
            this.delegate.reset();
        }
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        if (this.pluginSystemHasStarted && this.isDiagnosticsPlugin((PluginEvent)event)) {
            this.delegate.reset();
        }
    }

    private boolean isDiagnosticsPlugin(PluginEvent pluginEnabledEvent) {
        return pluginEnabledEvent.getPlugin().getKey().equals(DIAGNOSTICS_PLUGIN_KEY);
    }
}

