/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityFactory;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;

public class Delete {
    public static DeleteFromContext from(String entityName) {
        return new DeleteFromContext(entityName);
    }

    public static DeleteFromContext from(EntityFactory entityFactory) {
        return new DeleteFromContext(entityFactory.getEntityName());
    }

    public static class DeleteFromContext
    extends WhereClauseAwareDeleteContext {
        private final String entityName;

        private DeleteFromContext(String entityName) {
            this.entityName = entityName;
        }

        public DeleteWhereContext all() {
            return new DeleteWhereContext(this.entityName, new FieldMap());
        }

        public DeleteWhereContext byAnd(FieldMap fieldMap) {
            return fieldMap != null ? new DeleteWhereContext(this.entityName, fieldMap) : this.all();
        }

        public DeleteWhereContext whereIdEquals(Long id) {
            return new DeleteWhereContext(this.entityName, new FieldMap("id", (Object)id));
        }

        @Override
        public DeleteWhereContext whereEqual(String fieldName, String value) {
            return new DeleteWhereContext(this.entityName, new FieldMap(fieldName, (Object)value));
        }

        @Override
        public DeleteWhereContext whereEqual(String fieldName, Long value) {
            return new DeleteWhereContext(this.entityName, new FieldMap(fieldName, (Object)value));
        }

        @Override
        public DeleteWhereContext whereCondition(EntityCondition condition) {
            return this.all().whereCondition(condition);
        }
    }

    public static class DeleteWhereContext
    extends WhereClauseAwareDeleteContext {
        private final String entityName;
        private final FieldMap fieldMap;
        private final List<EntityCondition> conditions = new ArrayList<EntityCondition>();

        private DeleteWhereContext(String entityName, FieldMap fieldMap) {
            Validate.notBlank((CharSequence)entityName);
            Validate.notNull((Object)fieldMap);
            this.entityName = entityName;
            this.fieldMap = fieldMap;
        }

        @Override
        public DeleteWhereContext whereEqual(String fieldName, String value) {
            this.fieldMap.add(fieldName, (Object)value);
            return this;
        }

        @Override
        public DeleteWhereContext whereEqual(String fieldName, Long value) {
            this.fieldMap.add(fieldName, (Object)value);
            return this;
        }

        @Override
        public DeleteWhereContext whereCondition(EntityCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        String getEntityName() {
            return this.entityName;
        }

        FieldMap getFieldMap() {
            return this.fieldMap;
        }

        List<EntityCondition> getConditions() {
            return this.conditions;
        }

        public int execute(EntityEngine entityEngine) {
            return entityEngine.delete(this);
        }

        public int execute(OfBizDelegator ofBizDelegator) {
            if (this.conditions.isEmpty()) {
                return ofBizDelegator.removeByAnd(this.getEntityName(), (Map)this.getFieldMap());
            }
            Object condition = this.conditions.size() == 1 ? this.conditions.get(0) : new EntityConditionList(this.conditions, EntityOperator.AND);
            if (!this.fieldMap.isEmpty()) {
                condition = new EntityConditionList((List)ImmutableList.of((Object)new EntityFieldMap((Map)this.fieldMap, EntityOperator.AND), (Object)condition), EntityOperator.AND);
            }
            return ofBizDelegator.removeByCondition(this.entityName, condition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteWhereContext that = (DeleteWhereContext)o;
            return this.conditions.equals(that.conditions) && this.entityName.equals(that.entityName) && this.fieldMap.equals((Object)that.fieldMap);
        }

        public int hashCode() {
            return this.entityName.hashCode();
        }

        public String toString() {
            return String.format("[Entity = %s, Map = %s, condition = %s]", this.entityName, this.fieldMap, this.conditions);
        }
    }

    public static abstract class WhereClauseAwareDeleteContext {
        public abstract DeleteWhereContext whereEqual(String var1, String var2);

        public abstract DeleteWhereContext whereEqual(String var1, Long var2);

        public abstract DeleteWhereContext whereCondition(EntityCondition var1);

        public final DeleteWhereContext whereLike(String fieldName, String pattern) {
            return this.whereCondition((EntityCondition)new EntityExpr(fieldName, EntityOperator.LIKE, (Object)pattern));
        }

        public final DeleteWhereContext andEqual(String fieldName, String value) {
            return this.whereEqual(fieldName, value);
        }

        public final DeleteWhereContext andEqual(String fieldName, Long value) {
            return this.whereEqual(fieldName, value);
        }

        public final DeleteWhereContext andLike(String fieldName, String pattern) {
            return this.whereLike(fieldName, pattern);
        }

        public final DeleteWhereContext andCondition(EntityCondition condition) {
            return this.whereCondition(condition);
        }
    }
}

