/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityFactory;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityWhereString;
import org.ofbiz.core.entity.GenericValue;

public class EntityEngineImpl
implements EntityEngine {
    private OfBizDelegator ofBizDelegator;

    public EntityEngineImpl(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public <E> E createValue(EntityFactory<E> entityFactory, E value) {
        Map<String, Object> fieldMap = entityFactory.fieldMapFrom(value);
        GenericValue gv = this.ofBizDelegator.createValue(entityFactory.getEntityName(), fieldMap);
        return entityFactory.build(gv);
    }

    @Override
    public <E> void createValueWithoutId(EntityFactory<E> entityFactory, E value) {
        Map<String, Object> fieldMap = entityFactory.fieldMapFrom(value);
        this.ofBizDelegator.createValueWithoutId(entityFactory.getEntityName(), fieldMap);
    }

    @Override
    public <E> void updateValue(EntityFactory<E> entityFactory, E newValue) {
        GenericValue genericValue = this.ofBizDelegator.makeValue(entityFactory.getEntityName(), entityFactory.fieldMapFrom(newValue));
        this.ofBizDelegator.store(genericValue);
    }

    @Override
    public int execute(Update.WhereContext updateContext) {
        return updateContext.execute(this.ofBizDelegator);
    }

    @Override
    public int delete(Delete.DeleteWhereContext deleteContext) {
        return deleteContext.execute(this.ofBizDelegator);
    }

    @Override
    public <E> SelectQuery.ExecutionContext<E> run(SelectQuery<E> selectQuery) {
        return selectQuery.runWith(this.ofBizDelegator);
    }

    @Override
    public <E> int removeValue(EntityFactory<E> entityFactory, Long id) {
        return this.ofBizDelegator.removeById(entityFactory.getEntityName(), id);
    }

    @Override
    public <E> EntityEngine.SelectFromContext<E> selectFrom(EntityFactory<E> entity) {
        return new SelectFromContextImpl<E>(entity);
    }

    private class SelectFromContextImpl<E>
    implements EntityEngine.SelectFromContext<E> {
        private final EntityFactory<E> entity;

        public SelectFromContextImpl(EntityFactory<E> entity) {
            this.entity = entity;
        }

        @Override
        public EntityEngine.WhereContext<E> findAll() {
            return new WhereContextImpl<E>(this.entity, "");
        }

        @Override
        public E findById(Long id) {
            return this.whereEqual("id", id).singleValue();
        }

        @Override
        public EntityEngine.WhereEqualContext<E> whereEqual(String fieldName, String value) {
            return new WhereEqualContextImpl<E>(this.entity, fieldName, value);
        }

        @Override
        public EntityEngine.WhereEqualContext<E> whereEqual(String fieldName, Long value) {
            return new WhereEqualContextImpl<E>(this.entity, fieldName, value);
        }

        @Override
        public <V> EntityEngine.WhereInContext<E> whereIn(String fieldName, Collection<V> values) {
            return new WhereInContextImpl<E, V>(this.entity, fieldName, values);
        }
    }

    private abstract class AbstractWhereContext<E>
    implements EntityEngine.WhereContext<E> {
        final EntityFactory<E> entity;

        public AbstractWhereContext(EntityFactory<E> entity) {
            this.entity = entity;
        }

        @Override
        public List<E> orderBy(String ... orderByColumn) {
            List gvList = EntityEngineImpl.this.ofBizDelegator.findByCondition(this.entity.getEntityName(), this.getEntityCondition(), null, Arrays.asList(orderByColumn));
            return this.entity.buildList(gvList);
        }

        @Override
        public List<E> list() {
            List gvList = EntityEngineImpl.this.ofBizDelegator.findByCondition(this.entity.getEntityName(), this.getEntityCondition(), null, null);
            return this.entity.buildList(gvList);
        }

        @Override
        public E singleValue() {
            List<GenericValue> gvList = this.runQuery();
            switch (gvList.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.entity.build(gvList.get(0));
                }
            }
            throw new IllegalStateException("Too many rows returned for query on entity '" + this.entity.getEntityName() + "' condition: " + this.getEntityCondition());
        }

        private List<GenericValue> runQuery() {
            return EntityEngineImpl.this.ofBizDelegator.findByCondition(this.entity.getEntityName(), this.getEntityCondition(), null, null);
        }

        abstract EntityCondition getEntityCondition();
    }

    private class WhereContextImpl<E>
    extends AbstractWhereContext<E>
    implements EntityEngine.WhereContext<E> {
        private String whereClause;

        public WhereContextImpl(EntityFactory<E> entity, String whereClause) {
            super(entity);
            this.whereClause = whereClause;
        }

        @Override
        EntityCondition getEntityCondition() {
            return new EntityWhereString(this.whereClause);
        }
    }

    private class WhereInContextImpl<E, V>
    extends AbstractWhereContext<E>
    implements EntityEngine.WhereInContext<E> {
        private final String fieldName;
        private final Set<V> values;

        public WhereInContextImpl(EntityFactory<E> entity, String fieldName, Collection<V> values) {
            super(entity);
            this.fieldName = fieldName;
            this.values = values == null ? ImmutableSet.of() : ImmutableSet.copyOf(values);
        }

        @Override
        EntityCondition getEntityCondition() {
            return new EntityExpr(this.fieldName, EntityOperator.IN, this.values);
        }
    }

    private class WhereEqualAndContextImpl<E>
    extends AbstractWhereContext<E>
    implements EntityEngine.WhereEqualContext<E> {
        private final FieldMap fieldMap;

        public WhereEqualAndContextImpl(EntityFactory<E> entity, FieldMap fieldMap) {
            super(entity);
            this.fieldMap = fieldMap;
        }

        @Override
        EntityCondition getEntityCondition() {
            return new EntityFieldMap((Map)this.fieldMap, EntityOperator.AND);
        }

        @Override
        public EntityEngine.WhereEqualAndContext<E> andEqual(String fieldName, String value) {
            this.fieldMap.add(fieldName, (Object)value);
            return this;
        }

        @Override
        public EntityEngine.WhereEqualAndContext<E> andEqual(String fieldName, Long value) {
            this.fieldMap.add(fieldName, (Object)value);
            return this;
        }
    }

    private class WhereEqualContextImpl<E>
    extends AbstractWhereContext<E>
    implements EntityEngine.WhereEqualContext<E> {
        private final FieldMap fieldMap;

        public WhereEqualContextImpl(EntityFactory<E> entity, String fieldName, Object value) {
            super(entity);
            this.fieldMap = new FieldMap(fieldName, value);
        }

        @Override
        EntityCondition getEntityCondition() {
            return new EntityFieldMap((Map)this.fieldMap, EntityOperator.AND);
        }

        @Override
        public EntityEngine.WhereEqualAndContext<E> andEqual(String fieldName, String value) {
            this.fieldMap.add(fieldName, (Object)value);
            return new WhereEqualAndContextImpl(this.entity, this.fieldMap);
        }

        @Override
        public EntityEngine.WhereEqualAndContext<E> andEqual(String fieldName, Long value) {
            this.fieldMap.add(fieldName, (Object)value);
            return new WhereEqualAndContextImpl(this.entity, this.fieldMap);
        }
    }
}

