/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerFactory;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultListenerManager
implements ListenerManager,
Startable {
    public static final String REFRESH_LISTENERS = "Refresh Listeners";
    private static final Logger log = LoggerFactory.getLogger(DefaultListenerManager.class);
    private final EventPublisher eventPublisher;
    @ClusterSafe(value="This class sends a cluster message when refresh is required")
    private final Listeners listeners = new Listeners();
    private final OfBizDelegator ofBizDelegator;
    private final MessageConsumer messageConsumer;

    public DefaultListenerManager(EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, ClusterMessagingService messagingService) {
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.ofBizDelegator = (OfBizDelegator)Assertions.notNull((String)"ofBizDelegator", (Object)ofBizDelegator);
        this.messageConsumer = new MessageConsumer(this.listeners);
        messagingService.registerListener(REFRESH_LISTENERS, (ClusterMessageConsumer)this.messageConsumer);
    }

    public void start() throws Exception {
        this.listeners.start();
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public Map<String, JiraListener> getListeners() {
        ComponentManager componentManager = ComponentManager.getInstance();
        if (!componentManager.getState().isComponentsRegistered()) {
            throw new IllegalStateException("Listeners are not available until all components have been registered with the ComponentManager. Components can implement the " + Startable.class + " to be notified when the system is ready.");
        }
        return (Map)this.listeners.get();
    }

    public JiraListener createListener(String name, Class<? extends JiraListener> clazz) {
        this.ofBizDelegator.createValue("ListenerConfig", (Map)FieldMap.build((String)"name", (Object)name).add("clazz", (Object)clazz.getName()));
        this.refresh();
        return this.getListeners().get(name);
    }

    public void deleteListener(Class<? extends JiraListener> clazz) {
        List listenerConfigs = this.ofBizDelegator.findByAnd("ListenerConfig", (Map)FieldMap.build((String)"clazz", (Object)clazz.getName()));
        if (listenerConfigs.size() > 0) {
            this.ofBizDelegator.removeAll(new ArrayList(listenerConfigs));
            this.refresh();
        }
    }

    public void refresh() {
        this.listeners.resetAll();
        MessageHandlerService messageHandlerService = (MessageHandlerService)ComponentAccessor.getComponent(MessageHandlerService.class);
        messageHandlerService.sendMessage("ALL", new Message(REFRESH_LISTENERS, null));
    }

    public void onRefreshListeners() {
        this.listeners.resetAll();
    }

    private final class Listeners
    extends ResettableLazyReference<Map<String, JiraListener>> {
        private Listeners() {
        }

        protected Map<String, JiraListener> create() throws Exception {
            Map<String, JiraListener> jiraListenerMap = this.loadListeners();
            this.registerDBListeners(jiraListenerMap.values());
            return jiraListenerMap;
        }

        public void resetAll() {
            Map map = (Map)this.get();
            this.reset();
            for (JiraListener listener : map.values()) {
                DefaultListenerManager.this.eventPublisher.unregister((Object)listener);
            }
            this.get();
        }

        void start() {
            this.get();
        }

        private Map<String, JiraListener> loadListeners() {
            MapBuilder listeners = MapBuilder.newBuilder();
            List listenerConfigs = DefaultListenerManager.this.ofBizDelegator.findAll("ListenerConfig");
            if (listenerConfigs == null) {
                log.info("No Listeners to Load");
                return Collections.emptyMap();
            }
            for (GenericValue gv : listenerConfigs) {
                String className = gv.getString("clazz");
                String key = gv.getString("name");
                log.debug("Creating listener. Class: {}. Name: {}", (Object)className, (Object)key);
                try {
                    listeners.add((Object)key, (Object)ListenerFactory.getListener(className, this.getParameters(gv)));
                }
                catch (Exception e) {
                    log.error("Could not configure listener: " + key + " className:" + className, (Throwable)e);
                }
            }
            return listeners.toMap();
        }

        private Map<String, String> getParameters(GenericValue gv) {
            PropertySet ps = OFBizPropertyUtils.getPropertySet(gv);
            Collection paramKeys = ps.getKeys(5);
            MapBuilder params = MapBuilder.newBuilder();
            for (String key : paramKeys) {
                params.add((Object)key, (Object)ps.getString(key));
            }
            return params.toMap();
        }

        private void registerDBListeners(Collection<JiraListener> listeners) {
            for (JiraListener listener : listeners) {
                DefaultListenerManager.this.eventPublisher.register((Object)listener);
            }
        }
    }

    private static class MessageConsumer
    implements ClusterMessageConsumer {
        private final Listeners listeners;

        public MessageConsumer(Listeners listeners) {
            this.listeners = listeners;
        }

        public void receive(String channel, String message, String senderId) {
            if (channel.equals(DefaultListenerManager.REFRESH_LISTENERS)) {
                this.listeners.resetAll();
            }
        }
    }
}

