/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class SharedEntityUpdatedMetricsEvent
extends AbstractEvent {
    private final boolean isByOwner;
    private final boolean isPrivate;
    private final boolean hasUserUpdatedPermissions;
    private final boolean hasUserAddedEditors;
    private final SharedEntityEventType type;

    public SharedEntityUpdatedMetricsEvent(@Nonnull SharedEntityEventType type, @Nonnull SharedEntity oldEntity, @Nonnull SharedEntity newEntity, ApplicationUser userWhichUpdates) {
        this.type = type;
        this.isByOwner = this.isOwnerUpdatingEntity(newEntity, userWhichUpdates);
        Set oldPerm = oldEntity.getPermissions() == null ? Collections.emptySet() : oldEntity.getPermissions().getPermissionSet();
        Set newPerm = newEntity.getPermissions() == null ? Collections.emptySet() : newEntity.getPermissions().getPermissionSet();
        this.isPrivate = oldPerm.isEmpty();
        this.hasUserUpdatedPermissions = this.hasUserUpdatedPermissions(oldPerm, newPerm);
        this.hasUserAddedEditors = this.hasUserUpdatedPermissions && this.hasUserAddedEditors(oldPerm, newPerm);
    }

    @EventName
    public String getEventName() {
        return this.type.eventName;
    }

    public boolean getIsByOwner() {
        return this.isByOwner;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean getHasUserUpdatedPermissions() {
        return this.hasUserUpdatedPermissions;
    }

    public boolean getHasUserAddedEditors() {
        return this.hasUserAddedEditors;
    }

    private boolean isOwnerUpdatingEntity(@Nonnull SharedEntity sharedEntity, ApplicationUser userWhichUpdates) {
        return userWhichUpdates != null && userWhichUpdates.equals((Object)sharedEntity.getOwner());
    }

    private boolean hasUserUpdatedPermissions(@Nonnull Set<SharePermission> oldPerm, @Nonnull Set<SharePermission> newPerm) {
        return oldPerm.size() != newPerm.size() || !oldPerm.containsAll(newPerm);
    }

    private boolean hasUserAddedEditors(@Nonnull Set<SharePermission> oldPerm, @Nonnull Set<SharePermission> newPerm) {
        HashSet newPermMutable = Sets.newHashSet(newPerm);
        newPermMutable.removeAll(oldPerm);
        return newPermMutable.stream().anyMatch(permission -> permission.getRights().hasEditRightsGranted());
    }

    public String toString() {
        return "SharedEntityUpdatedMetricsEvent{isByOwner=" + this.isByOwner + ", isPrivate=" + this.isPrivate + ", hasUserUpdatedPermissions=" + this.hasUserUpdatedPermissions + ", hasUserAddedEditors=" + this.hasUserAddedEditors + "}";
    }

    public static enum SharedEntityEventType {
        DASHBOARD("jira.dashboard.updated"),
        FILTER("jira.filter.updated");

        String eventName;

        private SharedEntityEventType(String eventName) {
            this.eventName = eventName;
        }
    }
}

