/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.commit;

import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.commit.OnCommitEventManager;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import io.atlassian.fugue.Option;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OnCommitEventManagerImpl
implements OnCommitEventManager {
    private final TxnAwareEventFactory txnAwareEventFactory;

    public OnCommitEventManagerImpl(TxnAwareEventFactory txnAwareEventFactory) {
        this.txnAwareEventFactory = txnAwareEventFactory;
    }

    public void dispatchAsOnCommitEvent(Supplier<Object> eventSupplier) {
        this.txnAwareEventFactory.publishOnCommitEvent(() -> (OnCommitEvent)Option.option(eventSupplier.get()).map(notNullEvent -> new OnCommitEvent.OnCommitEventTransactionStatusSettable<Object>(){
            private final AtomicReference<OnCommitEvent.OnCommitEventTransactionStatus> transactionStatusRef = new AtomicReference();

            @Nonnull
            public Object getWrappedEvent() {
                return notNullEvent;
            }

            public void setOnCommitEventTransactionStatus(@Nonnull OnCommitEvent.OnCommitEventTransactionStatus onCommitEventTransactionStatus) {
                this.transactionStatusRef.compareAndSet(null, onCommitEventTransactionStatus);
            }

            @Nonnull
            public OnCommitEvent.OnCommitEventTransactionStatus getOnCommitEventTransactionStatus() {
                return (OnCommitEvent.OnCommitEventTransactionStatus)Option.option((Object)this.transactionStatusRef.get()).getOrElse((Object)OnCommitEvent.OnCommitEventTransactionStatus.UNKNOWN);
            }
        }).getOrNull());
    }

    public <T> void dispatchOnCommitEvent(Supplier<OnCommitEvent<T>> onCommitEventSupplier) {
        this.txnAwareEventFactory.publishOnCommitEvent(onCommitEventSupplier::get);
    }
}

