/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.diagnostics;

import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.detail.ThreadDumpProducer;
import com.atlassian.diagnostics.internal.platform.monitor.event.EventSystemMonitor;
import com.atlassian.diagnostics.internal.platform.monitor.event.EventSystemMonitorConfig;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class JiraEventSystemMonitor
extends EventSystemMonitor {
    private static final Logger log = LoggerFactory.getLogger(JiraEventSystemMonitor.class);
    private static final String DIAGNOSTICS_PLUGIN_KEY = "com.atlassian.jira.diagnostics";
    private boolean pluginSystemHasStarted = false;

    public JiraEventSystemMonitor(@Nonnull EventSystemMonitorConfig config, @Nonnull ThreadDumpProducer threadDumpProducer) {
        super(config, threadDumpProducer);
    }

    @EventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        this.pluginSystemHasStarted = true;
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            if (this.pluginSystemHasStarted && this.isDiagnosticsPlugin((PluginEvent)event)) {
                super.init((MonitoringService)ComponentAccessor.getOSGiComponentInstanceOfType(MonitoringService.class));
            }
        }
        catch (Exception exception) {
            log.debug("Unable to attach event system monitor", (Throwable)exception);
        }
    }

    private boolean isDiagnosticsPlugin(PluginEvent pluginEnabledEvent) {
        return pluginEnabledEvent.getPlugin().getKey().equals(DIAGNOSTICS_PLUGIN_KEY);
    }
}

