/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.jira.event.issue.EventTypesForIssueChange;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class EventTypesForIssueChangeImpl
implements EventTypesForIssueChange {
    @Override
    @Nonnull
    public List<Long> getEventTypeIdsForIssueUpdate(@Nonnull IssueUpdateBean issueUpdateBean) {
        ArrayList<Long> eventTypeIds = new ArrayList<Long>();
        Collection changesOnIssue = issueUpdateBean.getChangeItems();
        if (changesOnIssue != null && !changesOnIssue.isEmpty()) {
            Collection<String> fieldsChanged = this.extractFields(changesOnIssue);
            eventTypeIds.addAll(this.getIssueAssignRelatedEvents(fieldsChanged));
            eventTypeIds.addAll(this.getIssueMovedRelatedEvents(fieldsChanged));
            eventTypeIds.addAll(this.getCommentRelatedEvents(issueUpdateBean));
        }
        eventTypeIds.add(EventType.ISSUE_UPDATED_ID);
        return eventTypeIds;
    }

    @Nonnull
    private Collection<String> extractFields(@Nonnull Collection<ChangeItemBean> changesOnIssue) {
        ArrayList<String> fields = new ArrayList<String>();
        for (ChangeItemBean change : changesOnIssue) {
            fields.add(change.getField());
        }
        return fields;
    }

    @Nonnull
    private List<Long> getIssueAssignRelatedEvents(@Nonnull Collection<String> fieldsChanged) {
        if (fieldsChanged.contains("assignee")) {
            return Arrays.asList(EventType.ISSUE_ASSIGNED_ID);
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<Long> getIssueMovedRelatedEvents(@Nonnull Collection<String> fieldsChanged) {
        if (fieldsChanged.contains("project")) {
            return Arrays.asList(EventType.ISSUE_MOVED_ID);
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<Long> getCommentRelatedEvents(@Nonnull IssueUpdateBean issueUpdateBean) {
        if (EventType.ISSUE_COMMENT_DELETED_ID.equals(issueUpdateBean.getEventTypeId())) {
            return Arrays.asList(EventType.ISSUE_COMMENT_DELETED_ID);
        }
        return Collections.emptyList();
    }
}

