/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.type;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.model.querydsl.EventTypeDTO;
import com.atlassian.jira.model.querydsl.QEventType;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.util.EventTypeOrderTransformer;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.TransformingComparator;
import org.apache.commons.collections.map.MultiValueMap;

@EventComponent
public class DefaultEventTypeManager
implements EventTypeManager {
    public static final String EVENT_TYPE_ID = "eventTypeId";
    private final QueryDslAccessor accessor;
    private final OfBizDelegator delegator;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final WorkflowManager workflowManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final Comparator<EventType> eventTypeComparator = new TransformingComparator((Transformer)new EventTypeOrderTransformer());
    private final CachedReference<Map<Long, EventType>> eventTypesMapRef;

    public DefaultEventTypeManager(OfBizDelegator delegator, QueryDslAccessor accessor, ArchivingLicenseCheck archivingLicenseCheck, WorkflowManager workflowManager, NotificationSchemeManager notificationSchemeManager, CacheManager cacheFactory) {
        this.delegator = delegator;
        this.accessor = accessor;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.workflowManager = workflowManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.eventTypesMapRef = cacheFactory.getCachedReference(this.getClass().getName() + ".eventTypesMapRef", this::loadEventTypesMap);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    public Collection<EventType> getEventTypes() {
        return this.getEventTypesMap().values();
    }

    public Map<Long, EventType> getEventTypesMap() {
        return (Map)this.eventTypesMapRef.get();
    }

    public EventType getEventType(Long id) {
        EventType eventType = this.getEventTypesMap().get(id);
        if (eventType == null) {
            EventTypeDTO issueEventTypeGV = this.retrieveEntityByPrimaryKey(id);
            if (issueEventTypeGV == null) {
                throw new IllegalArgumentException("No event type with id " + id);
            }
            eventType = new EventType(issueEventTypeGV.toGenericValue(this.delegator));
        }
        return eventType;
    }

    public boolean isActive(EventType eventType) {
        return !this.getAssociatedWorkflows(eventType, true).isEmpty() || !this.getAssociatedNotificationSchemes(eventType).isEmpty();
    }

    public MultiMap getAssociatedWorkflows(EventType eventType, boolean statusCheck) {
        MultiValueMap workflowTransitionMap = new MultiValueMap();
        Collection workflows = this.workflowManager.getWorkflows();
        Long eventTypeId = eventType.getId();
        for (JiraWorkflow workflow : workflows) {
            Map transitionPostFunctionMap = this.workflowManager.getPostFunctionsForWorkflow(workflow);
            Set keys = transitionPostFunctionMap.keySet();
            for (ActionDescriptor actionDescriptor : keys) {
                Collection postFunctions = (Collection)transitionPostFunctionMap.get(actionDescriptor);
                for (FunctionDescriptor functionDescriptor : postFunctions) {
                    if (!functionDescriptor.getArgs().containsKey(EVENT_TYPE_ID) || !eventTypeId.equals(new Long((String)functionDescriptor.getArgs().get(EVENT_TYPE_ID)))) continue;
                    workflowTransitionMap.put((Object)workflow.getName(), (Object)actionDescriptor);
                    if (!statusCheck) continue;
                    return workflowTransitionMap;
                }
            }
        }
        return workflowTransitionMap;
    }

    public Map<Long, String> getAssociatedNotificationSchemes(EventType eventType) {
        return this.notificationSchemeManager.getSchemesMapByConditions((Map)FieldMap.build((String)EVENT_TYPE_ID, (Object)eventType.getId()));
    }

    public void addEventType(EventType eventType) {
        this.accessor.withNewConnection().execute(connection -> connection.insert(QEventType.EVENT_TYPE).set((Path)QEventType.EVENT_TYPE.name, eventType.getName()).set((Path)QEventType.EVENT_TYPE.description, eventType.getDescription()).set((Path)QEventType.EVENT_TYPE.templateId, eventType.getTemplateId()).executeWithId());
        this.clearCache();
    }

    public void editEventType(Long eventTypeId, String name, String description, Long templateId) {
        this.accessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QEventType.EVENT_TYPE).set((Path)QEventType.EVENT_TYPE.name, (Object)name).set((Path)QEventType.EVENT_TYPE.description, (Object)description).set(QEventType.EVENT_TYPE.templateId, (Object)templateId).where((Predicate)QEventType.EVENT_TYPE.id.eq((Object)eventTypeId)).execute());
        this.clearCache();
    }

    public void deleteEventType(Long eventTypeId) {
        this.accessor.withNewConnection().execute(connection -> connection.delete((RelationalPath<?>)QEventType.EVENT_TYPE).where((Predicate)QEventType.EVENT_TYPE.id.eq((Object)eventTypeId)).execute());
        this.clearCache();
    }

    public boolean isEventTypeExists(String issueEventTypeName) {
        if (issueEventTypeName == null) {
            throw new IllegalArgumentException("EventTypeName must not be null.");
        }
        for (EventType eventType : this.getEventTypes()) {
            if (!issueEventTypeName.equals(eventType.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isEventTypeExists(Long eventTypeId) {
        if (eventTypeId == null) {
            throw new IllegalArgumentException("EventTypeId must not be null.");
        }
        return this.getEventTypesMap().containsKey(eventTypeId);
    }

    private Map<Long, EventType> loadEventTypesMap() {
        ImmutableMap.Builder eventTypeMap = ImmutableMap.builder();
        for (EventType eventType : this.retrieveAllEntities()) {
            eventTypeMap.put((Object)eventType.getId(), (Object)eventType);
        }
        return eventTypeMap.build();
    }

    private List<EventType> retrieveAllEntities() {
        List dtos = this.accessor.withNewConnection().executeQuery(dbConnection -> ((SQLQuery)dbConnection.newSqlQuery().select((Expression)QEventType.EVENT_TYPE).from((Expression)QEventType.EVENT_TYPE)).fetch());
        List<EventType> eventTypes = dtos.stream().map(eventTypeDTO -> new EventType(eventTypeDTO.toGenericValue(this.delegator))).collect(Collectors.toList());
        if (!this.archivingLicenseCheck.isLicensedForIssueArchiving()) {
            eventTypes.removeIf(eventType -> eventType.getId().equals(EventType.ISSUE_ARCHIVED_ID) || eventType.getId().equals(EventType.ISSUE_RESTORED_ID));
        }
        Collections.sort(eventTypes, this.eventTypeComparator);
        return eventTypes;
    }

    private EventTypeDTO retrieveEntityByPrimaryKey(long id) {
        return this.accessor.withNewConnection().executeQuery(dbConnection -> (EventTypeDTO)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QEventType.EVENT_TYPE).from((Expression)QEventType.EVENT_TYPE)).where((Predicate)QEventType.EVENT_TYPE.id.eq((Object)id))).fetchFirst());
    }

    public void clearCache() {
        this.eventTypesMapRef.reset();
    }
}

