/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.FileStoreConfig;
import com.atlassian.jira.config.filestore.FileStoreConfigType;
import com.atlassian.jira.config.filestore.FileStoresConfig;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.filestore.FileStoreLoadingError;
import com.atlassian.jira.license.DataCenterOrDevModeCheck;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileStoreSwitcher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStoreSwitcher.class);
    @VisibleForTesting
    public static final String S3_BUCKET_PROPERTY_NAME = "jira.filestore.s3.bucket.name";
    @VisibleForTesting
    public static final String S3_REGION_PROPERTY_NAME = "jira.filestore.s3.bucket.region";
    @VisibleForTesting
    public static final String S3_MAX_CONCURRENCY = "jira.filestore.s3.max.concurrency";
    @VisibleForTesting
    public static final String S3_ENDPOINT_OVERRIDE_PROPERTY_NAME = "jira.filestore.s3.endpoint.override";
    private final JiraProperties jiraProperties;
    private final DataCenterOrDevModeCheck dataCenterOrDevModeCheck;
    private final FileStoresConfigurationLoader fileStoresConfigurationLoader;
    private final FileStoreAssociationTarget fileStoreAssociationTarget;
    private final Class<? extends T> defaultImplementation;
    private final Map<FileStoreConfigType, Class<? extends T>> fileStoreConfigTypeToProviderClassMap;
    private final Class<? extends T> invalidImplementation;

    protected FileStoreSwitcher(JiraProperties jiraProperties, DataCenterOrDevModeCheck dataCenterOrDevModeCheck, FileStoresConfigurationLoader fileStoresConfigurationLoader, FileStoreAssociationTarget fileStoreAssociationTarget, Class<? extends T> defaultImplementation, Map<FileStoreConfigType, Class<? extends T>> fileStoreConfigTypeToProviderClassMap, Class<? extends T> invalidImplementation) {
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
        this.dataCenterOrDevModeCheck = Objects.requireNonNull(dataCenterOrDevModeCheck);
        this.fileStoresConfigurationLoader = Objects.requireNonNull(fileStoresConfigurationLoader);
        this.fileStoreAssociationTarget = Objects.requireNonNull(fileStoreAssociationTarget);
        this.defaultImplementation = Objects.requireNonNull(defaultImplementation);
        this.fileStoreConfigTypeToProviderClassMap = Objects.requireNonNull(fileStoreConfigTypeToProviderClassMap);
        this.invalidImplementation = Objects.requireNonNull(invalidImplementation);
    }

    public final Class<? extends T> getComponentImplementation() {
        Either<String, Unit> canUseAlternateFileStore = this.canUseAlternateFileStore();
        if (canUseAlternateFileStore.isRight() && this.isS3ConfiguredViaSystemProperties() && this.fileStoreConfigTypeToProviderClassMap.containsKey((Object)FileStoreConfigType.S3)) {
            return this.fileStoreConfigTypeToProviderClassMap.get((Object)FileStoreConfigType.S3);
        }
        if (!this.fileStoresConfigurationLoader.configExists()) {
            return this.defaultImplementation;
        }
        String associationTargetName = this.fileStoreAssociationTarget.getAssociationTargetName();
        Optional<Either<FileStoreLoadingError, FileStoreConfig>> getFileStoreConfig = this.getFileStoreConfig();
        Optional<Class> provider = getFileStoreConfig.map(fileStoreConfigEither -> (Class)fileStoreConfigEither.fold(error -> {
            LOGGER.error(error.getMessage(), (Throwable)error.getException());
            return this.invalidImplementation;
        }, config -> {
            if (this.fileStoreConfigTypeToProviderClassMap.containsKey((Object)config.getType())) {
                return (Class)canUseAlternateFileStore.fold(e -> {
                    LOGGER.warn("{}. Defaulting to {} stored in the Jira home", e, (Object)associationTargetName);
                    return this.defaultImplementation;
                }, u -> this.fileStoreConfigTypeToProviderClassMap.get((Object)config.getType()));
            }
            LOGGER.warn("No {} file store provider found for {}. Defaulting to {} stored in the Jira home", new Object[]{associationTargetName, config.getType().getElementName(), associationTargetName});
            return this.defaultImplementation;
        }));
        return provider.orElse(this.defaultImplementation);
    }

    public Optional<Either<FileStoreLoadingError, FileStoreConfig>> getFileStoreConfig() {
        String associationTargetName = this.fileStoreAssociationTarget.getAssociationTargetName();
        Optional<Either<RuntimeException, FileStoresConfig>> fileStoresConfig = this.fileStoresConfigurationLoader.loadConfig();
        Optional<Either> associationConfigEither = fileStoresConfig.flatMap(either -> {
            Optional<Either> retVal = either.isLeft() ? Optional.of(Either.left((Object)((RuntimeException)either.left().get()))) : ((FileStoresConfig)either.right().get()).getAssociation(this.fileStoreAssociationTarget).map(Either::right);
            return retVal;
        });
        return associationConfigEither.map(associationEither -> (Either)associationEither.fold(e -> Either.left((Object)new FileStoreLoadingError("Error loading file store association config for " + associationTargetName, (RuntimeException)e)), associationConfig -> (Either)associationConfig.getFileStoreConfig().fold(e -> Either.left((Object)new FileStoreLoadingError("Error loading file store config for " + associationTargetName, (RuntimeException)e)), Either::right)));
    }

    protected final boolean isS3ConfiguredViaSystemProperties() {
        String bucketName = this.jiraProperties.getProperty(S3_BUCKET_PROPERTY_NAME);
        String bucketRegion = this.jiraProperties.getProperty(S3_REGION_PROPERTY_NAME);
        return StringUtils.isNotBlank((CharSequence)bucketName) && StringUtils.isNotBlank((CharSequence)bucketRegion);
    }

    protected Either<String, Unit> canUseAlternateFileStore() {
        if (this.dataCenterOrDevModeCheck.isDataCenterOrDevMode()) {
            return Either.right((Object)Unit.VALUE);
        }
        return Either.left((Object)"Alternate file stores are only supported for DC licensees");
    }
}

