/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.filestore.FileStoreInformation;
import java.util.Objects;
import javax.annotation.Nonnull;

public class FileSystemAttachmentFileStoreProvider
implements AttachmentFileStoreProvider {
    @VisibleForTesting
    static final String JIRA_HOME_HEADING_KEY = "admin.attachmentsettings.jirahome";
    private final FileStores fileStores;

    public FileSystemAttachmentFileStoreProvider(FileStores fileStores) {
        this.fileStores = Objects.requireNonNull(fileStores);
    }

    @Override
    @Nonnull
    public FileStore.Path getBasePath() {
        return this.fileStores.getHomeFilesystemPath().path(new String[]{"data", "attachments"});
    }

    @Override
    @Nonnull
    public FileStoreAnalyticInfo getFileStoreAnalyticInfo() {
        return FileStoreAnalyticInfo.fileSystemAnalyticInfo();
    }

    @Override
    public boolean isStoreInJiraHome() {
        return true;
    }

    @Override
    public FileStoreInformation getInformation() {
        FileStoreInformation.Builder infoBuilder = new FileStoreInformation.Builder();
        String attachmentPath = this.getBasePath().toString();
        return infoBuilder.setHeadingKey(JIRA_HOME_HEADING_KEY).addStringEntry(attachmentPath).build();
    }

    @Override
    public FileStoreAssociationTarget getAssociationTarget() {
        return FileStoreAssociationTarget.ATTACHMENTS;
    }
}

