/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.filestore.BackupFileStoreProvider;
import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.filestore.FileStoreInformation;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;

public class FileSystemBackupFileStoreProvider
implements BackupFileStoreProvider {
    private final FileStores fileStores;

    public FileSystemBackupFileStoreProvider(FileStores fileStores) {
        this.fileStores = Objects.requireNonNull(fileStores);
    }

    @Override
    @Nonnull
    public FileStore.Path getBasePath() {
        File absoluteFile = this.fileStores.getExportBackupsPath().asJavaFile().getAbsoluteFile();
        return new FilesystemFileStore(absoluteFile.toPath()).root();
    }

    @Override
    @Nonnull
    public FileStoreAnalyticInfo getFileStoreAnalyticInfo() {
        return FileStoreAnalyticInfo.fileSystemAnalyticInfo();
    }

    @Override
    public boolean isStoreInJiraHome() {
        return true;
    }

    @Override
    public FileStoreInformation getInformation() {
        return new FileStoreInformation.Builder().build();
    }
}

