/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.filestore.S3FileStoreProvider;
import javax.annotation.Nonnull;

public class S3AttachmentFileStoreProvider
extends S3FileStoreProvider
implements AttachmentFileStoreProvider {
    @VisibleForTesting
    static final String S3_ATTACHMENTS_PATH_PREFIX = "attachments";

    public S3AttachmentFileStoreProvider(JiraProperties jiraProperties, FileStoresConfigurationLoader fileStoresConfigurationLoader) {
        super(FileStoreAssociationTarget.ATTACHMENTS, jiraProperties, fileStoresConfigurationLoader);
    }

    @Override
    @Nonnull
    public FileStore.Path getBasePath() {
        return this.getS3FileStore().path(new String[]{S3_ATTACHMENTS_PATH_PREFIX});
    }

    @Override
    public boolean isStoreInJiraHome() {
        return false;
    }

    @Override
    public FileStoreAssociationTarget getAssociationTarget() {
        return FileStoreAssociationTarget.ATTACHMENTS;
    }
}

