/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.S3FileStoreConfig;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.filestore.BackupFileStoreProvider;
import com.atlassian.jira.filestore.S3FileStoreProvider;
import javax.annotation.Nonnull;

public class S3BackupFileStoreProvider
extends S3FileStoreProvider
implements BackupFileStoreProvider {
    @VisibleForTesting
    static final String S3_BACKUPS_PATH_PREFIX = "backups";

    public S3BackupFileStoreProvider(JiraProperties jiraProperties, FileStoresConfigurationLoader fileStoresConfigurationLoader) {
        super(FileStoreAssociationTarget.BACKUPS, jiraProperties, fileStoresConfigurationLoader);
    }

    @Override
    @Nonnull
    public FileStore.Path getBasePath() {
        return this.getS3FileStore().path(new String[]{S3_BACKUPS_PATH_PREFIX});
    }

    @Override
    public boolean isStoreInJiraHome() {
        return false;
    }

    public S3FileStoreConfig getS3FileStoreConfig() {
        return ((S3FileStoreProvider.ConfigAndFileStore)this.configAndFileStoreLazyReference.get()).getFileStoreConfig();
    }

    public String getS3BackupsPathPrefix() {
        return S3_BACKUPS_PATH_PREFIX;
    }
}

