/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.filestore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.impl.s3.S3Config;
import com.atlassian.dc.filestore.impl.s3.S3FileStore;
import com.atlassian.jira.config.filestore.FileStoreAssociationConfig;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.FileStoreConfig;
import com.atlassian.jira.config.filestore.FileStoreConfigType;
import com.atlassian.jira.config.filestore.FileStoresConfig;
import com.atlassian.jira.config.filestore.S3FileStoreConfig;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.filestore.FileStoreInformation;
import com.atlassian.jira.filestore.FileStoreProvider;
import com.atlassian.jira.util.EitherUtils;
import io.atlassian.util.concurrent.LazyReference;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class S3FileStoreProvider
implements FileStoreProvider {
    @VisibleForTesting
    static final String AMAZON_S3_HEADING_KEY = "admin.filestore.s3.heading";
    @VisibleForTesting
    static final String AMAZON_S3_REGION_ENTRY = "admin.filestore.s3.region";
    @VisibleForTesting
    static final String AMAZON_S3_BUCKET_NAME_ENTRY = "admin.filestore.s3.bucket";
    @VisibleForTesting
    static final String AMAZON_S3_ENDPOINT_ENTRY = "admin.filestore.s3.endpoint";
    private final FileStoreAssociationTarget associationTarget;
    private final JiraProperties jiraProperties;
    private final FileStoresConfigurationLoader fileStoresConfigurationLoader;
    protected final LazyReference<ConfigAndFileStore> configAndFileStoreLazyReference;

    protected S3FileStoreProvider(FileStoreAssociationTarget associationTarget, JiraProperties jiraProperties, FileStoresConfigurationLoader fileStoresConfigurationLoader) {
        this.associationTarget = Objects.requireNonNull(associationTarget);
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
        this.fileStoresConfigurationLoader = Objects.requireNonNull(fileStoresConfigurationLoader);
        this.configAndFileStoreLazyReference = new LazyReference<ConfigAndFileStore>(){

            protected ConfigAndFileStore create() {
                return S3FileStoreProvider.this.createS3FileStore();
            }
        };
    }

    public FileStoreConfig getFileStoreConfig() {
        return Objects.requireNonNull((ConfigAndFileStore)this.configAndFileStoreLazyReference.get()).getFileStoreConfig();
    }

    @Override
    @Nonnull
    public FileStoreAnalyticInfo getFileStoreAnalyticInfo() {
        return FileStoreAnalyticInfo.s3AnalyticInfo(Objects.requireNonNull((ConfigAndFileStore)this.configAndFileStoreLazyReference.get()).getFileStoreConfig().getEndpointOverride() != null);
    }

    @Override
    public FileStoreInformation getInformation() {
        S3FileStoreConfig config = Objects.requireNonNull((ConfigAndFileStore)this.configAndFileStoreLazyReference.get()).getFileStoreConfig();
        FileStoreInformation.Builder builder = new FileStoreInformation.Builder();
        builder.setHeadingKey(AMAZON_S3_HEADING_KEY).addI18nEntry(AMAZON_S3_REGION_ENTRY, Collections.singletonList(config.getRegion())).addI18nEntry(AMAZON_S3_BUCKET_NAME_ENTRY, Collections.singletonList(config.getBucketName()));
        if (StringUtils.isNotBlank((CharSequence)config.getEndpointOverride())) {
            builder.addI18nEntry(AMAZON_S3_ENDPOINT_ENTRY, Collections.singletonList(config.getEndpointOverride()));
        }
        return builder.build();
    }

    protected final FileStore getS3FileStore() {
        return Objects.requireNonNull((ConfigAndFileStore)this.configAndFileStoreLazyReference.get()).getFileStore();
    }

    private Optional<S3FileStoreConfig> getS3ConfigFromSystemProperties() {
        String bucketName = this.jiraProperties.getProperty("jira.filestore.s3.bucket.name");
        String bucketRegion = this.jiraProperties.getProperty("jira.filestore.s3.bucket.region");
        Integer maxConcurrency = this.jiraProperties.getInteger("jira.filestore.s3.max.concurrency", null);
        if (StringUtils.isNotBlank((CharSequence)bucketName) && StringUtils.isNotBlank((CharSequence)bucketRegion)) {
            return Optional.of(new S3FileStoreConfig("", bucketName, bucketRegion, maxConcurrency, this.jiraProperties.getProperty("jira.filestore.s3.endpoint.override")));
        }
        return Optional.empty();
    }

    @Nonnull
    private ConfigAndFileStore createS3FileStore() {
        String associationName = this.associationTarget.name().toLowerCase();
        S3FileStoreConfig config = this.getS3FileStoreConfig(associationName);
        URI endpointOverrideUri = S3FileStoreProvider.getEndpointOverrideUri(config);
        try {
            S3Config s3Config = S3Config.builder((String)config.getRegion(), (String)config.getBucketName()).setMaxConcurrencyPerTransfer(config.getMaxConcurrency()).setEndpointOverride(endpointOverrideUri).build();
            S3FileStore fileStore = new S3FileStore(s3Config);
            return new ConfigAndFileStore((FileStore)fileStore, config);
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            throw new IllegalStateException(String.format("Invalid S3 configuration: bucket name = '%s', region = '%s'", config.getBucketName(), config.getRegion()));
        }
    }

    private S3FileStoreConfig getS3FileStoreConfig(String associationName) {
        return this.getS3ConfigFromSystemProperties().orElseGet(() -> Optional.of((FileStoreConfig)EitherUtils.unwrapEither(((FileStoreAssociationConfig)this.fileStoresConfigurationLoader.loadConfig().flatMap(eitherCfg -> ((FileStoresConfig)eitherCfg.right().get()).getAssociation(this.associationTarget)).orElseThrow(() -> new IllegalStateException("Cannot create S3FileStore because no '" + associationName + "' association exists in filestore-config.xml"))).getFileStoreConfig().leftMap(e -> new IllegalStateException("Cannot create S3FileStore because no valid '" + associationName + "' config exists in filestore-config.xml")))).filter(cfg -> cfg.getType() == FileStoreConfigType.S3).map(S3FileStoreConfig.class::cast).orElseThrow(() -> new IllegalStateException("Cannot create S3FileStore because no valid S3 '" + associationName + "' config exists in filestore-config.xml")));
    }

    @Nullable
    private static URI getEndpointOverrideUri(S3FileStoreConfig config) {
        URI endpointOverrideUri;
        try {
            endpointOverrideUri = Optional.ofNullable(config.getEndpointOverride()).map(URI::create).orElse(null);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(String.format("Invalid Endpoint Override URI '%s'", config.getEndpointOverride()));
        }
        return endpointOverrideUri;
    }

    protected static final class ConfigAndFileStore {
        private final FileStore fileStore;
        private final S3FileStoreConfig fileStoreConfig;

        public ConfigAndFileStore(@Nonnull FileStore fileStore, @Nonnull S3FileStoreConfig fileStoreConfig) {
            this.fileStore = fileStore;
            this.fileStoreConfig = fileStoreConfig;
        }

        public FileStore getFileStore() {
            return this.fileStore;
        }

        public S3FileStoreConfig getFileStoreConfig() {
            return this.fileStoreConfig;
        }
    }
}

