/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.health.ModificationMigrationLocationService;
import com.atlassian.modzdetector.HashAlgorithm;
import com.atlassian.modzdetector.MD5HashAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ConfigurationHashService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationHashService.class);
    private static final HashAlgorithm hashAlgorithm = new MD5HashAlgorithm();
    private final ModificationMigrationLocationService locationService;

    public static ConfigurationHashService getInstance() {
        return new ConfigurationHashService(ModificationMigrationLocationService.getInstance());
    }

    public ConfigurationHashService(ModificationMigrationLocationService locationService) {
        this.locationService = Objects.requireNonNull(locationService);
    }

    Optional<String> calculateHash(Path configurationFile) {
        Path absolute = this.locationService.getInstallationRootDirectory().resolve(configurationFile);
        if (absolute.toFile().exists()) {
            return this.getHash(absolute);
        }
        return Optional.empty();
    }

    private Optional<String> getHash(Path customisedFilePath) {
        Optional<String> optional;
        block8: {
            InputStream is = Files.newInputStream(customisedFilePath, new OpenOption[0]);
            try {
                optional = Optional.ofNullable(hashAlgorithm.getHash(is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.info("Cannot calculate the hash value of the configuration file: {}", (Object)customisedFilePath.toFile().getAbsolutePath());
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }
}

