/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.AbstractHealthCheck;
import com.atlassian.jira.health.DefaultHealthCheckExecutor;
import com.atlassian.jira.health.DefaultHealthCheckRegistry;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckExecutor;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckRegistrar;
import com.atlassian.jira.health.HealthCheckRegistry;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsSender;
import com.atlassian.jira.health.analytics.NoOpHealthCheckAnalyticsSender;
import com.atlassian.jira.health.checks.StandaloneLicenseHealthCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.annotations.VisibleForTesting;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class HealthChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthChecks.class);
    private static volatile boolean complete;

    public static boolean isComplete() {
        return complete;
    }

    public static void runHealthChecks(LifecyclePhase lifecyclePhase) {
        HealthChecks.runHealthChecks(lifecyclePhase, Johnson.getEventContainer(), HealthCheckRegistrar::registerHealthChecks, new DefaultHealthCheckRegistry(), new DefaultHealthCheckExecutor());
    }

    private static void raiseHealthCheckResult(Event event, @Nullable URL kbUrl, String cause, String logMessage) {
        HealthChecks.raiseHealthCheckResult(event, kbUrl, cause, new DefaultHealthCheckExecutor(), Johnson.getEventContainer(), logMessage);
    }

    public static void raiseFatalStartupProblem() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("An error occurred while trying to start JIRA. We can't give you any more detail right now, we suggest checking the logs for more detail and contacting our support team.").addLineBreak(), HealthCheckMessageFormatter.string("See our documentation for more information on contacting our support team and creating a support zip."));
        HealthChecks.raiseHealthCheckResult(new Event(JohnsonEventType.STARTUP_UNEXPECTED.eventType(), "We couldn't start JIRA", messageFormatter.toHtml(), EventLevels.fatal()), UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/xIHdMQ"), "startup-exception", messageFormatter.toText());
    }

    static boolean isLicenseValid() {
        DefaultHealthCheckExecutor healthCheckExecutor = new DefaultHealthCheckExecutor();
        StandaloneLicenseHealthCheck licenseHealthCheck = StandaloneLicenseHealthCheck.getInstance(new HealthCheck[0]);
        JohnsonEventContainer eventContainer = Johnson.getEventContainer();
        HealthChecks.executeChecksAndRecordResults(healthCheckExecutor, Collections.singleton(licenseHealthCheck), null, eventContainer);
        return !eventContainer.hasEvent(e -> licenseHealthCheck.getId().equals(e.getAttribute((Object)"idKey")));
    }

    @VisibleForTesting
    static void raiseHealthCheckResult(Event event, @Nullable URL kbUrl, String cause, HealthCheckExecutor healthCheckExecutor, JohnsonEventContainer eventContainer, String logMessage) {
        Set<HealthCheck> healthChecks = Collections.singleton(new FailedHealthCheck(event, kbUrl, cause, logMessage));
        HealthChecks.executeChecksAndRecordResults(healthCheckExecutor, healthChecks, null, eventContainer);
    }

    @Nonnull
    private static HealthCheckAnalyticsSender getHealthCheckAnalyticsSender() {
        HealthCheckAnalyticsSender senderInPico = (HealthCheckAnalyticsSender)ComponentAccessor.getComponent(HealthCheckAnalyticsSender.class);
        if (senderInPico != null) {
            return senderInPico;
        }
        return new NoOpHealthCheckAnalyticsSender();
    }

    @VisibleForTesting
    static void runHealthChecks(LifecyclePhase lifecyclePhase, JohnsonEventContainer eventContainer, Consumer<HealthCheckRegistry> healthCheckRegistrar, HealthCheckRegistry healthCheckRegistry, HealthCheckExecutor healthCheckExecutor) {
        healthCheckRegistrar.accept(healthCheckRegistry);
        HealthChecks.executeChecksAndRecordResults(healthCheckExecutor, healthCheckRegistry.getAll(), lifecyclePhase, eventContainer);
        if (lifecyclePhase.isLast() || eventContainer.hasEvent(JohnsonEventPredicates.blocksStartup())) {
            complete = true;
        }
    }

    private static void executeChecksAndRecordResults(HealthCheckExecutor healthCheckExecutor, Collection<HealthCheck> healthChecks, @Nullable LifecyclePhase phase, JohnsonEventContainer eventContainer) {
        Set<HealthCheckResult> healthCheckResults = healthCheckExecutor.performHealthChecks(healthChecks, phase);
        healthCheckResults.stream().filter(check -> HealthChecks.isNew(check.getEvent(), eventContainer)).forEach(check -> HealthChecks.recordResult(eventContainer, check));
    }

    private static void recordResult(JohnsonEventContainer eventContainer, HealthCheckResult result) {
        Event event = result.getEvent();
        eventContainer.addEvent(event);
        HealthChecks.getHealthCheckAnalyticsSender().sendHealthCheckResult(event);
        HealthChecks.logEvent(event.getLevel(), event.getDesc(), result.getLogMessage());
    }

    private static boolean isNew(Event event, JohnsonEventContainer johnsonEventContainer) {
        return !johnsonEventContainer.getEvents().contains(event);
    }

    private static void logEvent(EventLevel eventLevel, String headline, String logMessage) {
        switch (eventLevel.getLevel()) {
            case "warning": {
                LOGGER.warn(headline);
                LOGGER.warn(logMessage);
                break;
            }
            case "fatal": 
            case "error": {
                LOGGER.error(headline);
                LOGGER.error(logMessage);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown EventLevel: " + eventLevel);
            }
        }
    }

    private HealthChecks() {
    }

    private static final class FailedHealthCheck
    extends AbstractHealthCheck {
        private final List<HealthCheckResult> healthCheckResult;

        FailedHealthCheck(Event event, @Nullable URL kbUrl, String cause, String logMessage) {
            super(Collections.emptySet());
            this.healthCheckResult = HealthCheckResult.fail(this, event, kbUrl, cause, logMessage);
        }

        @Override
        public List<HealthCheckResult> perform(LifecyclePhase lifecyclePhase) {
            return this.healthCheckResult;
        }

        @Override
        public final boolean isApplicableFor(LifecyclePhase phase) {
            return true;
        }
    }
}

