/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.earlystartup.DeferredAnalyticsEventService;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.health.ModificationMigrationLocationService;
import com.atlassian.jira.health.ModificationsManager;
import com.atlassian.jira.health.ModificationsMigrationService;
import com.atlassian.jira.health.analytics.HeliumDisplayAnalyticsEvent;
import com.atlassian.jira.health.web.JohnsonTemplateContext;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CustomisedConfigurationsHealthCheck
extends HealthCheckTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomisedConfigurationsHealthCheck.class);
    public static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/adminjiraserver/upgrading-jira-server-manual-938846939.html");
    private final ModificationsManager modificationsManager;
    private final ModificationMigrationLocationService locationService;
    private final ModificationsMigrationService migrationService;
    private final DeferredAnalyticsEventService eventService;

    public CustomisedConfigurationsHealthCheck(HealthCheck ... prerequisites) {
        this(ModificationsManager.getInstance(), ModificationMigrationLocationService.getInstance(), ModificationsMigrationService.getInstance(), (DeferredAnalyticsEventService)ComponentAccessor.getComponent(DeferredAnalyticsEventService.class), prerequisites);
    }

    @VisibleForTesting
    CustomisedConfigurationsHealthCheck(ModificationsManager modificationsManager, ModificationMigrationLocationService locationService, ModificationsMigrationService migrationService, DeferredAnalyticsEventService eventService, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.modificationsManager = Objects.requireNonNull(modificationsManager);
        this.locationService = Objects.requireNonNull(locationService);
        this.migrationService = Objects.requireNonNull(migrationService);
        this.eventService = Objects.requireNonNull(eventService);
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PRE_DATABASE_LAUNCH));
    }

    @Override
    public List<HealthCheckResult> doPerform() {
        this.backupModifications();
        Set<Path> customisedFiles = this.modificationsManager.getSavedModificationsFromModificationsFolder();
        if (customisedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Path> filesWhichCantBeCopied = this.migrationService.checkCopyingNotPossible(customisedFiles);
        if (filesWhichCantBeCopied.equals(customisedFiles)) {
            this.eventService.publish(new HeliumDisplayAnalyticsEvent(0, filesWhichCantBeCopied.size()));
            return this.failureHealthCheckResult(customisedFiles);
        }
        Sets.SetView autoCopyableFiles = Sets.difference(customisedFiles, filesWhichCantBeCopied);
        this.eventService.publish(new HeliumDisplayAnalyticsEvent(autoCopyableFiles.size(), filesWhichCantBeCopied.size()));
        return this.copyAutomaticallyHealthCheckResult((Collection<Path>)autoCopyableFiles, filesWhichCantBeCopied);
    }

    private void backupModifications() {
        try {
            FileUtils.deleteDirectory((File)this.locationService.getCustomisationsDirectory().toFile());
            File originalDirectory = this.locationService.getOriginalCustomisationsDirectory().toFile();
            if (originalDirectory.exists()) {
                FileUtils.copyDirectory((File)originalDirectory, (File)this.locationService.getCustomisationsDirectory().toFile());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error creating copy of modifications directory", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOGGER.warn("Problem creating copy of modifications directory", (Throwable)e);
        }
    }

    private List<HealthCheckResult> copyAutomaticallyHealthCheckResult(Collection<Path> filesWeCanTryToCopy, Collection<Path> filesWhichCantBeCopied) {
        return this.createResult(filesWeCanTryToCopy, filesWhichCantBeCopied, "We detected some configuration changes", "We detected some configuration changes");
    }

    private List<HealthCheckResult> failureHealthCheckResult(Collection<Path> customisedConfigurations) {
        HealthCheckMessageFormatter messageFormatter = CustomisedConfigurationsHealthCheck.createFormatter(customisedConfigurations);
        return this.createResult(Collections.emptySet(), customisedConfigurations, "Custom changes have not been carried over", messageFormatter.toText());
    }

    private List<HealthCheckResult> createResult(Collection<Path> filesWeCanTryToCopy, Collection<Path> filesWhichCantBeCopied, String description, String logMessage) {
        return HealthCheckResult.fail(this, CustomisedConfigurationsHealthCheck.createEvent(filesWeCanTryToCopy, filesWhichCantBeCopied, description), KB_URL, "configuration-changes", logMessage);
    }

    public static Event createEvent(Collection<Path> filesWeCanTryToCopy, Collection<Path> filesWhichCantBeCopied, String description) {
        return CustomisedConfigurationsHealthCheck.createEvent(filesWeCanTryToCopy, filesWhichCantBeCopied, description, true);
    }

    public static Event createEvent(Collection<Path> filesWeCanTryToCopy, Collection<Path> filesWhichCantBeCopied, String description, boolean dismissible) {
        Event event = new Event(JohnsonEventType.UPGRADE.eventType(), description, null, JohnsonEventLevel.WARNING.eventLevel());
        if (dismissible) {
            event.addAttribute((Object)"dismissible", (Object)true);
        }
        event.addAttribute((Object)"templateContext", (Object)new ConfigCustomisationTemplateContext(CustomisedConfigurationsHealthCheck.pathsToStrings(filesWeCanTryToCopy), CustomisedConfigurationsHealthCheck.pathsToStrings(filesWhichCantBeCopied)));
        return event;
    }

    private static Set<String> pathsToStrings(Collection<Path> paths) {
        return paths.stream().map(Path::toString).collect(Collectors.toSet());
    }

    public static HealthCheckMessageFormatter createFormatter(Collection<Path> customisedConfigurations) {
        return new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("The listed configuration files contain custom changes. To keep your current configuration, re-apply these custom changes to the new version of the files during upgrade.")).addLineBreak().appendList(customisedConfigurations.stream().map(p -> HealthCheckMessageFormatter.string(p.toString())).collect(Collectors.toList())).addLineBreak().append(HealthCheckMessageFormatter.string("Note: Make sure you only copy over the changes not the entire files.")).addLineBreak();
    }

    @VisibleForTesting
    public static class ConfigCustomisationTemplateContext
    implements JohnsonTemplateContext {
        private final String type = "configCustomisation";
        private final Collection<String> filesThatCanBeCopied;
        private final Collection<String> filesThatCannotBeCopied;

        public ConfigCustomisationTemplateContext(Collection<String> filesThatCanBeCopied, Collection<String> filesThatCannotBeCopied) {
            this.filesThatCanBeCopied = filesThatCanBeCopied;
            this.filesThatCannotBeCopied = filesThatCannotBeCopied;
        }

        @Override
        public String getType() {
            return "configCustomisation";
        }

        public Collection<String> getFilesThatCanBeCopied() {
            return this.filesThatCanBeCopied;
        }

        public Collection<String> getFilesThatCannotBeCopied() {
            return this.filesThatCannotBeCopied;
        }
    }
}

