/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.internal.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DbConfigurationAndConnectionCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(DbConfigurationAndConnectionCheck.class);
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/7Kn9Mw");

    public DbConfigurationAndConnectionCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.DATABASE_CONFIGURED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        DatabaseConfigurationManager dbConfigManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        if (dbConfigManager == null) {
            log.warn("Cannot check database connection because DatabaseConfigurationManager is not available.");
            return Collections.emptyList();
        }
        try {
            dbConfigManager.getDatabaseConfiguration().testConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());
            return Collections.emptyList();
        }
        catch (BootstrapException e) {
            HealthCheckMessageFormatter errorMessage = this.getErrorMessage();
            Event event = new Event(JohnsonEventType.DATABASE.eventType(), "JIRA couldn't connect to your database", errorMessage.toHtml(), JohnsonEventLevel.FATAL.eventLevel());
            return this.healthCheckResult(event, errorMessage);
        }
    }

    private HealthCheckMessageFormatter getErrorMessage() {
        HealthCheckMessageFormatter formatter = new HealthCheckMessageFormatter();
        formatter.append(HealthCheckMessageFormatter.string("JIRA failed to establish a connection to your database.")).addLineBreak();
        formatter.append(HealthCheckMessageFormatter.string("This could be because:")).addLineBreak();
        formatter.appendList(HealthCheckMessageFormatter.string("Your database isn't running"), HealthCheckMessageFormatter.string("The configuration of your dbconfig.xml file is incorrect (user, password, or database URL etc.)"), HealthCheckMessageFormatter.string("There is a network issue between JIRA and your database (e.g. firewall, database doesn't allow remote access etc.)"));
        formatter.addLineBreak();
        formatter.append(HealthCheckMessageFormatter.string("There are several other solutions you can try, review our documentation and see what works for you.")).addLineBreak();
        return formatter;
    }

    private List<HealthCheckResult> healthCheckResult(Event event, HealthCheckMessageFormatter errorMessage) {
        return HealthCheckResult.fail(this, event, KB_URL, "bootstrap-exception", errorMessage.toText());
    }
}

