/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.checks.JiraHomeMessageFactory;
import com.atlassian.jira.startup.JiraHomeStartupCheckFailure;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultJiraHomeMessageFactory
implements JiraHomeMessageFactory {
    @Override
    @Nonnull
    public JiraHomeMessageFactory.JiraHomeMessage getMessage(JiraHomeStartupCheckFailure failure) {
        HealthCheckMessageFormatter formatter = new HealthCheckMessageFormatter();
        switch (failure.getReason()) {
            case NOT_CONFIGURED: {
                String headline = "We can't locate your JIRA home directory";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Your JIRA home directory has important information on how JIRA works, so you need to make sure it's set up correctly.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("We can't locate your JIRA home directory", message);
            }
            case PATH_NOT_ABSOLUTE: 
            case PATH_NOT_ABSOLUTE_BUT_WINDOWS_LIKE: {
                String headline = "Your jira.home path isn't absolute";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Your current jira.home is:")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getConfiguredHome()))).append(HealthCheckMessageFormatter.string("which is not absolute.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("Your jira.home path isn't absolute", message);
            }
            case PATH_COLLISION_WEBAPP_SERVLET: {
                String headline = "Your jira.home path is conflicting with your webapp servlet path";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Your jira.home path")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getConfiguredHome()))).append(HealthCheckMessageFormatter.string(" can't be the same as your webapp servlet path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getWebappPath()))).append(HealthCheckMessageFormatter.string(".")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("Your jira.home path is conflicting with your webapp servlet path", message);
            }
            case PATH_COLLISION_WEBAPP_SERVLET_PARENT: {
                String headline = "Your jira.home path is a parent of your webapp servlet path";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Your jira.home path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(" can't be the parent directory your webapp servlet path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getWebappPath()))).append(HealthCheckMessageFormatter.string(".")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("Your jira.home path is a parent of your webapp servlet path", message);
            }
            case PATH_COLLISION_WEBAPP_SERVLET_CHILD: {
                String headline = "Your webapp servlet path is a parent of your jira.home path";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Your webapp servlet path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getWebappPath()))).append(HealthCheckMessageFormatter.string(" can't be the parent directory your jira.home path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(".")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("Your webapp servlet path is a parent of your jira.home path", message);
            }
            case PATH_COLLISION_WEBAPP_SERVLET_FAILED: {
                String headline = "JIRA can't connect to your jira.home or webapp servlet";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Make sure that your jira.home path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(" and webapp servlet path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getWebappPath()))).append(HealthCheckMessageFormatter.string(" are accessible by JIRA, and that JIRA has read and write access.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("JIRA can't connect to your jira.home or webapp servlet", message);
            }
            case NOT_A_DIR: {
                String headline = "Your JIRA home isn't a directory";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Your jira.home path ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(" needs to point to a directory, as JIRA needs to be able to read and write files to this location.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("Your JIRA home isn't a directory", message);
            }
            case CREATION_FAILED_SUBDIR: {
                String headline = "JIRA can't create required subdirectories";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("JIRA needs to create and write to subdirectories in your jira.home directory ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(". Ensure JIRA has permission to do this.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("JIRA can't create required subdirectories", message);
            }
            case CREATION_NOT_POSSIBLE: 
            case CREATION_FAILED_SECURITY: 
            case CREATION_FAILED_WRITE_PERMISSION_SUBDIR: {
                String headline = "JIRA couldn't create the jira.home directory";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Ensure JIRA has permission to create and write to the jira.home directory ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(".")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("JIRA couldn't create the jira.home directory", message);
            }
            case LOCK_ALREADY_EXISTS: {
                String headline = "The jira.home directory is locked";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("The jira.home directory ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(" is locked by another running instance of JIRA. ")).append(HealthCheckMessageFormatter.string("Your jira.home directory can only be used by one running JIRA instance.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("The jira.home directory is locked", message);
            }
            case LOCK_FAILED_CREATION: {
                String headline = "JIRA can't create a lock for your jira.home directory";
                HealthCheckMessageFormatter message = formatter.append(HealthCheckMessageFormatter.string("Your jira.home directory ")).append(HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string(failure.getProposedHome()))).append(HealthCheckMessageFormatter.string(" can only be used by one running JIRA instance. ")).append(HealthCheckMessageFormatter.string("This instance needs to create a lock to make sure another instance can't access the jira.home directory. ")).append(HealthCheckMessageFormatter.string("Ensure JIRA has read and write access to the jira.home directory.")).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation for more information on setting your JIRA home."));
                return new JiraHomeMessageFactory.JiraHomeMessage("JIRA can't create a lock for your jira.home directory", message);
            }
        }
        throw new UnsupportedOperationException("Cannot generate a message for " + failure.getReason());
    }
}

