/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.filestore.FileStoreConfig;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.filestore.AttachmentFileStoreSwitcher;
import com.atlassian.jira.filestore.AvatarFileStoreSwitcher;
import com.atlassian.jira.filestore.BackupFileStoreSwitcher;
import com.atlassian.jira.filestore.FileStoreLoadingError;
import com.atlassian.jira.filestore.FileStoreSwitcher;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.license.DataCenterOrDevModeCheck;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class FileStoreConfigurationHealthCheck
extends HealthCheckTemplate {
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/display/ADMINJIRASERVER/Configuring+Amazon+S3+Object+Storage#ConfiguringAmazonS3objectstorage-TroubleshootAmazonS3");
    private Supplier<List<FileStoreSwitcher>> allSwitchers;

    public FileStoreConfigurationHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.allSwitchers = () -> Arrays.asList(new AvatarFileStoreSwitcher((JiraProperties)ComponentAccessor.getComponent(JiraProperties.class), (FileStoresConfigurationLoader)ComponentAccessor.getComponent(FileStoresConfigurationLoader.class), (DataCenterOrDevModeCheck)ComponentAccessor.getComponent(DataCenterOrDevModeCheck.class)), new AttachmentFileStoreSwitcher((JiraProperties)ComponentAccessor.getComponent(JiraProperties.class), (DataCenterOrDevModeCheck)ComponentAccessor.getComponent(DataCenterOrDevModeCheck.class), (FileStoresConfigurationLoader)ComponentAccessor.getComponent(FileStoresConfigurationLoader.class), (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)), new BackupFileStoreSwitcher((JiraProperties)ComponentAccessor.getComponent(JiraProperties.class), (DataCenterOrDevModeCheck)ComponentAccessor.getComponent(DataCenterOrDevModeCheck.class), (FileStoresConfigurationLoader)ComponentAccessor.getComponent(FileStoresConfigurationLoader.class)));
    }

    @VisibleForTesting
    FileStoreConfigurationHealthCheck(Supplier<List<FileStoreSwitcher>> allSwitchers, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.allSwitchers = allSwitchers;
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return EnumSet.of(LifecyclePhase.POST_DATABASE_ACTIVATED);
    }

    @Override
    @Nonnull
    protected List<HealthCheckResult> doPerform() {
        if (!((DataCenterOrDevModeCheck)ComponentAccessor.getComponent(DataCenterOrDevModeCheck.class)).isDataCenterOrDevMode()) {
            return Collections.emptyList();
        }
        List<String> allErrorMessages = this.getAllErrorMessages(this.getAllSwitchers());
        if (!allErrorMessages.isEmpty()) {
            String errorMessageAsText = this.getFormattedErrorMessage(allErrorMessages).toText();
            String errorMessageAsHtml = this.getFormattedErrorMessage(allErrorMessages).toHtml();
            Event event = new Event(JohnsonEventType.SETUP.eventType(), String.format("The %s isn't configured correctly", "filestore-config.xml"), errorMessageAsHtml, JohnsonEventLevel.FATAL.eventLevel());
            return HealthCheckResult.fail(this, event, KB_URL, "bootstrap-exception", errorMessageAsText);
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    List<FileStoreSwitcher> getAllSwitchers() {
        return (List)this.allSwitchers.get();
    }

    private void addFileStoreLoadingErrorMessageIfPresent(Optional<Either<FileStoreLoadingError, FileStoreConfig>> fileStoreConfigEither, List<String> allErrors) {
        Optional<FileStoreLoadingError> fileStoreLoadingError = fileStoreConfigEither.filter(Either::isLeft).map(either -> (FileStoreLoadingError)either.left().get());
        if (fileStoreLoadingError.isPresent()) {
            RuntimeException ex = fileStoreLoadingError.get().getException();
            if (ex.getCause() != null) {
                allErrors.add(ex.getCause().getMessage());
                return;
            }
            allErrors.add(ex.getMessage());
        }
    }

    private List<String> getAllErrorMessages(List<FileStoreSwitcher> fileStoreSwitchers) {
        ArrayList<String> allErrors = new ArrayList<String>();
        fileStoreSwitchers.forEach(s -> this.addFileStoreLoadingErrorMessageIfPresent(s.getFileStoreConfig(), allErrors));
        return allErrors;
    }

    private HealthCheckMessageFormatter getFormattedErrorMessage(List<String> allErrors) {
        HealthCheckMessageFormatter formatter = new HealthCheckMessageFormatter();
        formatter.append(HealthCheckMessageFormatter.string(String.format("Jira couldn't parse the %s file located in your home directory. The file contains invalid XML syntax or incorrect configuration.", "filestore-config.xml"))).addLineBreak();
        formatter.append(HealthCheckMessageFormatter.string("Fix the detected issues and restart Jira:")).addLineBreak();
        allErrors.stream().distinct().forEach(e -> formatter.append(HealthCheckMessageFormatter.string(e)).addLineBreak());
        return formatter;
    }
}

