/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.AbstractHealthCheck;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.BuildVersionLicenseCheckFailure;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.web.action.admin.ConfirmNewInstallationWithOldLicense;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ProhibitedServerLicenseHealthCheck
extends AbstractHealthCheck {
    @VisibleForTesting
    static final String EVENT_DESCRIPTION = "This Jira version doesn't support Server licenses";
    @VisibleForTesting
    static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/Cb3xN");
    private final BuildVersionLicenseCheck buildVersionLicenseCheck;

    public ProhibitedServerLicenseHealthCheck(HealthCheck ... prerequisites) {
        this((BuildVersionLicenseCheck)ComponentAccessor.supplierOf(BuildVersionLicenseCheck.class).get(), prerequisites);
    }

    @VisibleForTesting
    ProhibitedServerLicenseHealthCheck(BuildVersionLicenseCheck buildVersionLicenseCheck, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.buildVersionLicenseCheck = buildVersionLicenseCheck;
    }

    @Override
    @Nonnull
    public List<HealthCheckResult> perform(LifecyclePhase phase) {
        LicenseCheck.Result result = this.buildVersionLicenseCheck.evaluate();
        if (result.isPass()) {
            return Collections.emptyList();
        }
        BuildVersionLicenseCheckFailure licenseCheckFailure = (BuildVersionLicenseCheckFailure)result;
        if (licenseCheckFailure.getFailureType() == BuildVersionLicenseCheckFailure.FailureType.SERVER_LICENSE_FOUND) {
            return ProhibitedServerLicenseHealthCheck.failBecauseServerLicenseWasUsed(this, result.getFailedLicenses());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isApplicableFor(LifecyclePhase phase) {
        return phase == LifecyclePhase.PRE_PLUGIN_SYSTEM_START;
    }

    static List<HealthCheckResult> failBecauseServerLicenseWasUsed(HealthCheck healthCheck, List<LicenseDetails> failedLicenses) {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("Ensure you have a valid Data Center license, ")).appendLink(ConfirmNewInstallationWithOldLicense.getRelativeUrl(), "update your license key", false).append(HealthCheckMessageFormatter.string(", and restart your instance."));
        EventType eventType = JohnsonEventType.INCOMPATIBLE_LICENSE.eventType();
        Event event = new Event(eventType, EVENT_DESCRIPTION, messageFormatter.toHtml(), EventLevels.error());
        return HealthCheckResult.fail(healthCheck, event, KB_URL, eventType.getType(), messageFormatter.toText());
    }
}

