/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.health.AbstractHealthCheck;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.health.checks.ProhibitedServerLicenseHealthCheck;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.BuildVersionLicenseCheckFailure;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.web.action.admin.ConfirmNewInstallationWithOldLicense;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.LazyReference;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class StandaloneLicenseHealthCheck
extends AbstractHealthCheck {
    @VisibleForTesting
    static final String EVENT_DESCRIPTION = "We found a problem with your JIRA license";
    @VisibleForTesting
    static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/Cb3xN");
    private final Supplier<BuildUtilsInfo> buildUtilsInfoSupplier;
    private final Supplier<BuildVersionLicenseCheck> buildVersionLicenseCheckSupplier;
    private final Supplier<DateTimeFormatter> dateTimeFormatterSupplier;
    @ClusterSafe(value="Reflects the version of JIRA running on this node")
    private final LazyReference<String> buildVersionRef = new LazyReference<String>(){

        protected String create() {
            BuildUtilsInfo buildUtilsInfo = Objects.requireNonNull(StandaloneLicenseHealthCheck.this.buildUtilsInfoSupplier.get());
            return buildUtilsInfo.getVersion();
        }
    };

    @Nonnull
    public static StandaloneLicenseHealthCheck getInstance(HealthCheck ... prerequisites) {
        return new StandaloneLicenseHealthCheck(ComponentAccessor.supplierOf(BuildUtilsInfo.class), ComponentAccessor.supplierOf(BuildVersionLicenseCheck.class), ComponentAccessor.supplierOf(DateTimeFormatter.class), prerequisites);
    }

    @VisibleForTesting
    StandaloneLicenseHealthCheck(Supplier<BuildUtilsInfo> buildUtilsInfoSupplier, Supplier<BuildVersionLicenseCheck> buildVersionLicenseCheckSupplier, Supplier<DateTimeFormatter> dateTimeFormatterSupplier, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.buildUtilsInfoSupplier = Objects.requireNonNull(buildUtilsInfoSupplier);
        this.buildVersionLicenseCheckSupplier = Objects.requireNonNull(buildVersionLicenseCheckSupplier);
        this.dateTimeFormatterSupplier = Objects.requireNonNull(dateTimeFormatterSupplier);
    }

    @Override
    public List<HealthCheckResult> perform(LifecyclePhase phase) {
        BuildVersionLicenseCheck buildVersionLicenseCheck = Objects.requireNonNull(this.buildVersionLicenseCheckSupplier.get());
        LicenseCheck.Result result = buildVersionLicenseCheck.evaluate();
        if (result.isPass()) {
            return Collections.emptyList();
        }
        BuildVersionLicenseCheckFailure licenseCheckFailure = (BuildVersionLicenseCheckFailure)result;
        switch (licenseCheckFailure.getFailureType()) {
            case NO_LICENSE_FOUND: {
                return this.failBecauseOfNoLicense();
            }
            case VERSION_1_LICENSE_FOUND: {
                return this.failBecauseVersionOneLicenseFound();
            }
            case LICENSE_PAST_MAINTENANCE_DATE: {
                return this.failBecauseOfExpiredLicenses(result.getFailedLicenses());
            }
            case SERVER_LICENSE_FOUND: {
                return ProhibitedServerLicenseHealthCheck.failBecauseServerLicenseWasUsed(this, result.getFailedLicenses());
            }
        }
        throw new UnsupportedOperationException("Unsupported failure: " + licenseCheckFailure.getFailureType());
    }

    @Override
    public boolean isApplicableFor(LifecyclePhase phase) {
        return true;
    }

    private List<HealthCheckResult> failBecauseOfNoLicense() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("We can't detect an installed license. JIRA requires an installed license to start.")).append(HealthCheckMessageFormatter.string(" If you don't have a license, you can obtain one at ")).appendLink("http://my.atlassian.com", "my.atlassian.com", true).append(HealthCheckMessageFormatter.string(". Enter your license ")).appendLink(StandaloneLicenseHealthCheck.getLicenseEntryPath(), "here", false).append(HealthCheckMessageFormatter.string(" to allow JIRA to start.")).addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on licensing errors."));
        EventType eventType = JohnsonEventType.LICENSE_INVALID.eventType();
        Event event = new Event(eventType, EVENT_DESCRIPTION, messageFormatter.toHtml(), EventLevels.error());
        return HealthCheckResult.fail(this, event, KB_URL, eventType.getType(), messageFormatter.toText());
    }

    private List<HealthCheckResult> failBecauseVersionOneLicenseFound() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("Version 1 licenses are incompatible with this version of JIRA.")).append(HealthCheckMessageFormatter.string(" You can obtain a new license or generate an evaluation license at ")).appendLink("http://my.atlassian.com", "my.atlassian.com", true).append(HealthCheckMessageFormatter.string(". Enter your license ")).appendLink(StandaloneLicenseHealthCheck.getLicenseEntryPath(), "here", false).append(HealthCheckMessageFormatter.string(" to allow JIRA to start.")).addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on licensing errors."));
        EventType eventType = JohnsonEventType.LICENSE_TOO_OLD.eventType();
        Event event = new Event(eventType, EVENT_DESCRIPTION, messageFormatter.toHtml(), EventLevels.error());
        return HealthCheckResult.fail(this, event, KB_URL, eventType.getType(), messageFormatter.toText());
    }

    private List<HealthCheckResult> failBecauseOfExpiredLicenses(Collection<LicenseDetails> expiredLicenses) {
        return expiredLicenses.stream().flatMap(license -> this.toExpiredLicenseResult((LicenseDetails)license).stream()).collect(Collectors.toList());
    }

    private List<HealthCheckResult> toExpiredLicenseResult(LicenseDetails expiredLicense) {
        String jiraBuildVersion = Objects.requireNonNull((String)this.buildVersionRef.get());
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter().append(HealthCheckMessageFormatter.string("Your current ")).append(HealthCheckMessageFormatter.string(expiredLicense.getApplicationDescription())).append(HealthCheckMessageFormatter.string(" license doesn't allow you to upgrade to this version of JIRA (")).append(HealthCheckMessageFormatter.string(jiraBuildVersion)).append(HealthCheckMessageFormatter.string("). ")).append(HealthCheckMessageFormatter.string(expiredLicense.getApplicationDescription())).append(HealthCheckMessageFormatter.string(" expired on ")).append(HealthCheckMessageFormatter.string(this.getDateTimeFormatter().format(expiredLicense.getMaintenanceExpiryDate()))).append(HealthCheckMessageFormatter.string(", and you can currently only upgrade to versions released prior to this date.")).append(HealthCheckMessageFormatter.string(" Alternatively you can renew your license at ")).appendLink("http://my.atlassian.com", "my.atlassian.com", true).append(HealthCheckMessageFormatter.string(" which will allow you to upgrade to this version of JIRA (")).append(HealthCheckMessageFormatter.string(jiraBuildVersion)).append(HealthCheckMessageFormatter.string("). You can enter your new license ")).appendLink(StandaloneLicenseHealthCheck.getLicenseEntryPath(), "here", false).append(HealthCheckMessageFormatter.string(".")).addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on licensing errors."));
        EventType eventType = StandaloneLicenseHealthCheck.getPastMaintenanceEventType(expiredLicense);
        Event event = new Event(eventType, EVENT_DESCRIPTION, messageFormatter.toHtml(), EventLevels.error());
        return HealthCheckResult.fail(this, event, KB_URL, eventType.getType(), messageFormatter.toText());
    }

    private static EventType getPastMaintenanceEventType(LicenseDetails licensePastMaintenance) {
        JohnsonEventType johnsonEventType = licensePastMaintenance.isEnterpriseLicenseAgreement() ? JohnsonEventType.SUBSCRIPTION_EXPIRED : JohnsonEventType.LICENSE_TOO_OLD;
        return johnsonEventType.eventType();
    }

    private DateTimeFormatter getDateTimeFormatter() {
        return Objects.requireNonNull(this.dateTimeFormatterSupplier.get());
    }

    private static String getLicenseEntryPath() {
        return ConfirmNewInstallationWithOldLicense.getRelativeUrl();
    }
}

