/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.secrets.api.SecretStoreException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSecretStoreRetrievalHealthCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSecretStoreRetrievalHealthCheck.class);
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/7Kn9Mw");

    public DatabaseSecretStoreRetrievalHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PRE_DATABASE_LAUNCH));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        DatabaseConfigurationManager databaseConfigurationManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        return this.performCheck(databaseConfigurationManager);
    }

    @VisibleForTesting
    protected List<HealthCheckResult> performCheck(DatabaseConfigurationManager databaseConfigurationManager) {
        try {
            databaseConfigurationManager.getDatabaseConfiguration();
        }
        catch (SecretStoreException sse) {
            return this.getHealthCheckResults(sse);
        }
        catch (Exception e) {
            log.warn("Exception when reading database configuration: ", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<HealthCheckResult> getHealthCheckResults(SecretStoreException sse) {
        HealthCheckMessageFormatter errorMessage = this.getErrorMessage(sse);
        Event event = new Event(JohnsonEventType.DATABASE.eventType(), "Jira couldn't read the database configuration", errorMessage.toHtml(), JohnsonEventLevel.FATAL.eventLevel());
        return this.healthCheckResult(event, errorMessage);
    }

    private HealthCheckMessageFormatter getErrorMessage(SecretStoreException sse) {
        HealthCheckMessageFormatter formatter = new HealthCheckMessageFormatter();
        formatter.append(HealthCheckMessageFormatter.string("Jira failed to retrieve the JDBC password from the configured Secret Store.")).addLineBreak();
        if (Objects.nonNull(ExceptionUtils.getRootCause((Throwable)sse))) {
            formatter.appendList(HealthCheckMessageFormatter.string(ExceptionUtils.getRootCause((Throwable)sse).toString()));
        } else {
            formatter.appendList(HealthCheckMessageFormatter.string(ExceptionUtils.getMessage((Throwable)sse)));
        }
        formatter.addLineBreak();
        formatter.append(HealthCheckMessageFormatter.string("Review our documentation for more details on configuring secrets.")).addLineBreak();
        return formatter;
    }

    private List<HealthCheckResult> healthCheckResult(Event event, HealthCheckMessageFormatter errorMessage) {
        return HealthCheckResult.fail(this, event, KB_URL, "bootstrap-exception", errorMessage.toText());
    }
}

