/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MinimumUpgradableVersionHealthCheck
extends HealthCheckTemplate {
    private static final String INSTRUCTIONS_URL = ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.confluence.upgrade.guide.for.old.versions");

    public MinimumUpgradableVersionHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_DATABASE_ACTIVATED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return new MinimumUpgradableVersionHealthCheckCalculator(this, UpgradeUtils.tableExists("project"), Integer.parseInt(new BuildUtilsInfoImpl().getMinimumUpgradableBuildNumber()), UpgradeUtils.getJIRABuildVersionNumber()).check();
    }

    @VisibleForTesting
    static class MinimumUpgradableVersionHealthCheckCalculator {
        private static final URL KB_URL = UrlBuilder.createURL((String)INSTRUCTIONS_URL);
        private final MinimumUpgradableVersionHealthCheck healthCheck;
        private final boolean isDatabaseSetup;
        private final int minimumUpgradableBuildNumber;
        private final int currentDatabaseBuildNumber;

        MinimumUpgradableVersionHealthCheckCalculator(MinimumUpgradableVersionHealthCheck healthCheck, boolean isDatabaseSetup, int minimumUpgradableBuildNumber, int currentDatabaseBuildNumber) {
            this.healthCheck = healthCheck;
            this.isDatabaseSetup = isDatabaseSetup;
            this.minimumUpgradableBuildNumber = minimumUpgradableBuildNumber;
            this.currentDatabaseBuildNumber = currentDatabaseBuildNumber;
        }

        List<HealthCheckResult> check() {
            if (this.isDatabaseSetup) {
                if (this.currentDatabaseBuildNumber > 0 && this.currentDatabaseBuildNumber < this.minimumUpgradableBuildNumber) {
                    HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
                    messageFormatter.append(HealthCheckMessageFormatter.string(String.format("The data in your database is currently on version %d, and is too old to be upgraded. The minimum version that can be upgraded is %d. You need to upgrade your data to at least the minimum version before upgrading to the final version.", this.currentDatabaseBuildNumber, this.minimumUpgradableBuildNumber))).addLineBreak().append(HealthCheckMessageFormatter.string("Review our documentation and see what works for you."));
                    return HealthCheckResult.fail(this.healthCheck, new Event(JohnsonEventType.DATABASE.eventType(), "Upgrade Failed", messageFormatter.toHtml(), JohnsonEventLevel.FATAL.eventLevel()), KB_URL, "db-data-too-old", messageFormatter.toText());
                }
                return Collections.emptyList();
            }
            return Collections.emptyList();
        }
    }
}

