/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.internal.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlJdbcUrlHealthCheck
extends HealthCheckTemplate {
    private static final Logger log = LoggerFactory.getLogger(MySqlJdbcUrlHealthCheck.class);
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/sIkjN");

    public MySqlJdbcUrlHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.DATABASE_CONFIGURED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return this.performCheck(new DatabaseConfigurationSummary((DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class)));
    }

    @VisibleForTesting
    List<HealthCheckResult> performCheck(DatabaseConfigurationSummary databaseConfigurationSummary) {
        return databaseConfigurationSummary.getConnectionUri().map(connectionUriString -> this.checkConnectionUri(databaseConfigurationSummary, (String)connectionUriString)).orElse(Collections.emptyList());
    }

    private List<HealthCheckResult> checkConnectionUri(DatabaseConfigurationSummary databaseConfigurationSummary, String connectionUriString) {
        if (databaseConfigurationSummary.isMySql() && MySqlJdbcUrlHealthCheck.isUriIncompatibleWithMySql57(connectionUriString)) {
            boolean isWarning = this.canWorkWithCurrentConfiguration(databaseConfigurationSummary);
            HealthCheckMessageFormatter messageFormatter = this.createErrorMessage(isWarning);
            return this.createHealthCheckResult(messageFormatter, isWarning);
        }
        return Collections.emptyList();
    }

    private EventLevel getEventSeverity(boolean isWarning) {
        return isWarning ? EventLevels.warning() : EventLevels.fatal();
    }

    private List<HealthCheckResult> createHealthCheckResult(HealthCheckMessageFormatter messageFormatter, boolean warningOnly) {
        String errorDescription = "We've found an error in your database connection URL";
        String warningDescription = "We've found a problem with your database connection URL";
        String eventDescription = warningOnly ? "We've found a problem with your database connection URL" : "We've found an error in your database connection URL";
        Event event = new Event(JohnsonEventType.DATABASE.eventType(), eventDescription, messageFormatter.toHtml(), this.getEventSeverity(warningOnly));
        if (warningOnly) {
            event.addAttribute((Object)"dismissible", (Object)true);
        }
        return HealthCheckResult.fail(this, event, KB_URL, "mysql-engine-type", messageFormatter.toText());
    }

    private HealthCheckMessageFormatter createErrorMessage(boolean isWarning) {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("The connection URL in your "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("dbconfig.xml")), HealthCheckMessageFormatter.string(" file contains the "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("storage_engine")), HealthCheckMessageFormatter.string(" parameter, which has been deprecated. "), isWarning ? HealthCheckMessageFormatter.string("This should be replaced with the ") : HealthCheckMessageFormatter.string("This needs to be replaced with the "), HealthCheckMessageFormatter.tag("code", HealthCheckMessageFormatter.string("default_storage_engine")), HealthCheckMessageFormatter.string(" parameter.")).addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on changing your connection URL."));
        return messageFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean canWorkWithCurrentConfiguration(DatabaseConfigurationSummary databaseConfigurationSummary) {
        Connection connection = null;
        try {
            connection = this.getConnection(databaseConfigurationSummary);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to connect to the database: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DatabaseUtil.closeQuietly(connection);
        }
    }

    @VisibleForTesting
    static boolean isUriIncompatibleWithMySql57(String uri) {
        String query = URIUtil.getQuery((String)uri);
        return !StringUtils.contains((CharSequence)query, (CharSequence)"default_storage_engine") && StringUtils.contains((CharSequence)query, (CharSequence)"storage_engine");
    }

    private Connection getConnection(DatabaseConfigurationSummary databaseConfigurationSummary) throws Exception {
        return databaseConfigurationSummary.getConnection();
    }

    @VisibleForTesting
    static class DatabaseConfigurationSummary {
        private final DatabaseConfigurationManager databaseConfigurationManager;

        DatabaseConfigurationSummary(DatabaseConfigurationManager databaseConfigurationManager) {
            this.databaseConfigurationManager = databaseConfigurationManager;
        }

        Optional<String> getConnectionUri() {
            return this.databaseConfigurationManager.isDatabaseSetup() ? Optional.ofNullable(this.databaseConfigurationManager.getDatabaseConfiguration()).map(DatabaseConfig::getDatasourceInfo).map(DatasourceInfo::getJdbcDatasource).map(JdbcDatasourceInfo::getUri) : Optional.empty();
        }

        boolean isMySql() {
            return this.databaseConfigurationManager.getDatabaseConfiguration().isMySql();
        }

        public Connection getConnection() throws BootstrapException {
            return this.databaseConfigurationManager.getDatabaseConfiguration().getDatasource().getConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());
        }
    }
}

