/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.help.HelpUrlsApplicationKeyProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;

public class DefaultHelpUrlsApplicationKeyProvider
implements HelpUrlsApplicationKeyProvider {
    private final JiraAuthenticationContext ctx;
    private final ApplicationRoleManager applicationRoleManager;

    public DefaultHelpUrlsApplicationKeyProvider(JiraAuthenticationContext ctx, ApplicationRoleManager applicationRoleManager) {
        this.ctx = ctx;
        this.applicationRoleManager = applicationRoleManager;
    }

    @Override
    @Nonnull
    public ApplicationKey getApplicationKeyForUser() {
        ApplicationUser loggedInUser = this.ctx.getLoggedInUser();
        if (loggedInUser == null) {
            return ApplicationKeys.CORE;
        }
        return this.getSingleNonCoreKeyOrDefault(loggedInUser, ApplicationKeys.CORE);
    }

    private ApplicationKey getSingleNonCoreKeyOrDefault(ApplicationUser loggedInUser, ApplicationKey defaultKey) {
        ApplicationKey singleNonCoreKey = this.getSingleNonCoreKey(loggedInUser);
        return singleNonCoreKey != null ? singleNonCoreKey : defaultKey;
    }

    private ApplicationKey getSingleNonCoreKey(ApplicationUser loggedInUser) {
        ApplicationKey singleNonCoreKey = null;
        for (ApplicationRole applicationRole : this.applicationRoleManager.getRolesForUser(loggedInUser)) {
            if (!this.isApplicable(applicationRole)) continue;
            if (singleNonCoreKey == null) {
                singleNonCoreKey = applicationRole.getKey();
                continue;
            }
            return null;
        }
        return singleNonCoreKey;
    }

    private boolean isApplicable(ApplicationRole applicationRole) {
        return applicationRole.isDefined() && !ApplicationKeys.CORE.equals((Object)applicationRole.getKey());
    }
}

